/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.derby;

import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class DerbySQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public DerbySQLCreatorFactory(ITable table) {
        super(table);
    }

    public String VisibleColumnSizePattern() {
        return "^VARCHAR";
    }

    public String[] getSupportColumnType() {
        return new String[]{"BIGINT", "CHAR", "DATE", "DECIMAL", "DOUBLE", "DOUBLE PRECISION", "FLOAT", "INTEGER", "NUMERIC", "REAL", "SMALLINT", "TIME", "TIMESTAMP", "VARCHAR", "CLOB", "LONG VARCHAR", "BLOB", "CHAR FOR BIT DATA", "VARCHAR FOR BIT DATA", "LONG VARCHAR FOR BIT DATA"};
    }

    public String createRenameTableDDL(String newTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("RENAME TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" TO ");
        sb.append(SQLUtil.encodeQuotation(newTableName));
        return sb.toString();
    }

    public String createRenameColumnDDL(Column from, Column to) {
        return null;
    }

    public String[] createAddColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" ADD COLUMN ");
        sb.append(SQLUtil.encodeQuotation(column.getName()));
        sb.append(" ");
        sb.append(column.getTypeName());
        if (this.isVisibleColumnSize(column.getTypeName())) {
            sb.append("(");
            sb.append(column.getSize());
            sb.append(")");
        }
        if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
            sb.append(" DEFAULT ");
            sb.append(column.getDefaultValue());
        }
        StringBuffer sb2 = new StringBuffer();
        if (column.isNotNull()) {
            sb2.append("ALTER TABLE ");
            sb2.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
            sb2.append(" ALTER COLUMN  ");
            sb2.append(SQLUtil.encodeQuotation(column.getName()));
            sb2.append(" NOT NULL");
        }
        return new String[]{sb.toString(), sb2.toString()};
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        StringBuffer sb = new StringBuffer();
        if (!from.getSize().equals(to.getSize()) && "VARCHAR".equals(to.getTypeName())) {
            sb.append("ALTER TABLE ");
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
            sb.append(" ALTER COLUMN ");
            sb.append(SQLUtil.encodeQuotation(to.getName()));
            sb.append(" SET DATA TYPE VARCHAR(");
            sb.append(to.getSize());
            sb.append(")");
        }
        StringBuffer sb2 = new StringBuffer();
        if (!from.getDefaultValue().equals(to.getDefaultValue())) {
            sb2.append("ALTER TABLE ");
            sb2.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
            sb2.append(" ALTER COLUMN ");
            sb2.append(SQLUtil.encodeQuotation(to.getName()));
            sb2.append(" DEFAULT ");
            if ("".equals(to.getDefaultValue())) {
                sb2.append("NULL");
            } else {
                sb2.append(to.getDefaultValue());
            }
        }
        StringBuffer sb3 = new StringBuffer();
        sb3.append("ALTER TABLE ");
        sb3.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb3.append(" ALTER COLUMN ");
        sb3.append(SQLUtil.encodeQuotation(to.getName()));
        if (to.isNotNull()) {
            sb3.append(" NOT NULL");
        } else {
            sb3.append(" NULL");
        }
        return new String[]{sb.toString(), sb2.toString(), sb3.toString()};
    }

    public String createCommentOnTableDDL(String commnets) {
        return null;
    }

    public String createCommentOnColumnDDL(Column column) {
        return null;
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        return null;
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return false;
    }

    public boolean supportsModifyColumnType() {
        return false;
    }

    public boolean supportsRemarks() {
        return false;
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }

    public boolean supportsRollbackDDL() {
        return true;
    }

    public String createCreateIndexDDL(String indexName, Column[] columns, int indexType) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE");
        if (1 == indexType) {
            sb.append(" UNIQUE");
        } else if (2 == indexType) {
            sb.append(" BITMAP");
        }
        sb.append(" INDEX ");
        sb.append("\"");
        sb.append(this.table.getSchemaName());
        sb.append("\"");
        sb.append(".");
        sb.append(indexName);
        sb.append(" ON ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createDropIndexDDL(String indexName) {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP INDEX ");
        sb.append("\"");
        sb.append(this.table.getSchemaName());
        sb.append("\"");
        sb.append(".");
        sb.append(indexName);
        return sb.toString();
    }

    public String createCreateConstraintPKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" PRIMARY KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintUKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" UNIQUE ");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintFKDDL(String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" FOREIGN KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        sb.append(" REFERENCES ");
        sb.append(refTable.getSqlTableName());
        sb.append("(");
        i = 0;
        while (i < refColumns.length) {
            Column refColumn = refColumns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(refColumn.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        if (onDeleteCascade) {
            sb.append(" ON DELETE CASCADE");
        }
        return sb.toString();
    }

    public String createCreateConstraintCheckDDL(String constraintName, String check) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" CHECK");
        sb.append("(");
        sb.append(check);
        sb.append(")");
        return sb.toString();
    }

    public String createDropConstraintDDL(String constraintName, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        if ("PRIMARY KEY".equals(type)) {
            sb.append(" DROP PRIMARY KEY ");
        } else {
            sb.append(" DROP CONSTRAINT ");
            sb.append(constraintName);
        }
        return sb.toString();
    }
}

