/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class Validator {
    public static final String entry_Check(String filedName, String text) {
        if (text == null || text.length() == 0) {
            return String.valueOf(filedName) + " is not null.";
        }
        return null;
    }

    public static final String length_Check(String filedName, String text, int maxBytes) {
        if (text == null || text.equals("")) {
            return null;
        }
        int cnt = 0;
        int i = 0;
        while (i < text.length()) {
            String s = text.substring(i, i + 1);
            cnt += s.getBytes().length;
            ++i;
        }
        if (cnt > maxBytes) {
            return String.valueOf(filedName) + " is " + maxBytes + "byte limit.";
        }
        return null;
    }

    public static final String numeric_Check(String filedName, String text) {
        if (text == null || text.equals("")) {
            return null;
        }
        int i = 0;
        while (i < text.length()) {
            char chr = text.charAt(i);
            if (chr < '0' || chr > '9') {
                return String.valueOf(filedName) + " is numeric only,";
            }
            ++i;
        }
        return null;
    }

    public static final String decimal_Check(String filedName, String text) {
        try {
            new BigDecimal(text);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(filedName) + " is numeric only.";
        }
        return null;
    }

    public static final String date_Check(String filedName, String text) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            df.parse(text);
        }
        catch (ParseException parseException) {
            return String.valueOf(filedName) + " is the format of " + "yyyy-MM-dd" + ".";
        }
        return null;
    }

    public static final String timestamp_Check(String filedName, String text) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            df.parse(text);
        }
        catch (ParseException parseException) {
            return String.valueOf(filedName) + " should be input " + "yyyy-MM-dd HH:mm:ss" + ".";
        }
        return null;
    }

    public static final String timestamp2_Check(String filedName, String text) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            df.parse(text);
        }
        catch (ParseException parseException) {
            return String.valueOf(filedName) + " should be input " + "yyyy-MM-dd HH:mm:ss.SSS" + ".";
        }
        return null;
    }

    public static final String time_Check(String filedName, String text) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        try {
            df.parse(text);
        }
        catch (ParseException parseException) {
            return String.valueOf(filedName) + " should be input " + "HH:mm:ss" + ".";
        }
        return null;
    }

    public static final String boolean_Check(String filedName, String text) {
        String str = text.toLowerCase();
        if ("true".equals(str) || "false".equals(str)) {
            return null;
        }
        return String.valueOf(filedName) + " is true or false";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String tinyint_Check(String filedName, String text) {
        block3: {
            try {
                if (Validator.decimal_Check(filedName, text) != null) return String.valueOf(filedName) + "  is range from -128 to 127. ";
                int value = Integer.parseInt(text);
                if (-128 > value || value > 127) break block3;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return String.valueOf(filedName) + "  is range from -128 to 127. ";
            }
        }
        return String.valueOf(filedName) + "  is range from -128 to 127. ";
    }
}

