/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.DefaultMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.core.rule.derby.DerbyMappingFactory;
import zigen.plugin.db.core.rule.mysql.MySQLMappingFactory;
import zigen.plugin.db.core.rule.oracle.OracleMappingFactory;
import zigen.plugin.db.core.rule.postgresql.PostgreSQLMappingFactory;
import zigen.plugin.db.core.rule.symfoware.SymfowareMappingFactory;

public abstract class AbstractMappingFactory
implements IMappingFactory {
    protected SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected SimpleDateFormat timeStampFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean convertUnicode;
    protected String nullSymbol;
    private static Map map = new HashMap();

    public static IMappingFactory getFactory(IDBConfig config) {
        return AbstractMappingFactory.getFactory(config.getDriverName(), config.isConvertUnicode());
    }

    public static IMappingFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode) {
        try {
            return AbstractMappingFactory.getFactory(objMet.getDriverName(), isConvertUnicode);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("DriverName\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public static IMappingFactory getFactory(String driverName, boolean isConvertUnicode) {
        IMappingFactory factory = null;
        String key = String.valueOf(driverName) + ":" + isConvertUnicode;
        if (map.containsKey(key)) {
            factory = (IMappingFactory)map.get(key);
            factory.setConvertUnicode(isConvertUnicode);
        } else {
            switch (DBType.getType(driverName)) {
                case 1: {
                    factory = new OracleMappingFactory(isConvertUnicode);
                    break;
                }
                case 3: {
                    factory = new SymfowareMappingFactory(isConvertUnicode);
                    break;
                }
                case 2: {
                    factory = new MySQLMappingFactory(isConvertUnicode);
                    break;
                }
                case 9: {
                    factory = new PostgreSQLMappingFactory(isConvertUnicode);
                    break;
                }
                case 6: {
                    factory = new DerbyMappingFactory(isConvertUnicode);
                    break;
                }
                default: {
                    factory = new DefaultMappingFactory(isConvertUnicode);
                }
            }
            map.put(key, factory);
        }
        factory.setNullSymbol(DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol"));
        return factory;
    }

    public abstract boolean canModifyDataType(int var1);

    public abstract Object getObject(ResultSet var1, int var2) throws Exception;

    public abstract void setObject(PreparedStatement var1, int var2, TableColumn var3, Object var4) throws Exception;

    protected Date toDate(String s) throws Exception {
        return Date.valueOf(s);
    }

    protected Time toTime(String s) throws Exception {
        return Time.valueOf(s);
    }

    protected Timestamp toTimestamp(String str) throws Exception {
        SimpleDateFormat df = null;
        java.util.Date date = null;
        df = str.length() <= 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        date = df.parse(str);
        return new Timestamp(date.getTime());
    }

    protected Timestamp toTimestamp2(String str) throws Exception {
        SimpleDateFormat df = null;
        java.util.Date date = null;
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        date = df.parse(str);
        return new Timestamp(date.getTime());
    }

    protected byte[] toBytes(Object obj) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        bos.close();
        return bos.toByteArray();
    }

    protected String toBinary(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hx = Integer.toHexString(bytes[i] & 0xFF);
            String prefix = "";
            int j = hx.length();
            while (j < 2) {
                prefix = String.valueOf(prefix) + '0';
                ++j;
            }
            sb.append(prefix);
            sb.append(hx);
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] toByteArray(InputStream is) {
        ByteArrayOutputStream baos = null;
        byte[] buf = new byte[1024];
        int count = 0;
        baos = new ByteArrayOutputStream();
        while ((count = is.read(buf)) != -1) {
            if (count <= 0) continue;
            baos.write(buf, 0, count);
        }
        byte[] byArray = baos.toByteArray();
        if (baos == null) return byArray;
        try {
            baos.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException e) {
            try {
                DbPlugin.log(e);
                if (baos == null) return null;
            }
            catch (Throwable throwable) {
                if (baos == null) throw throwable;
                try {
                    baos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                baos.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public String getNullSymbol() {
        return this.nullSymbol;
    }

    public void setNullSymbol(String nullSymbol) {
        this.nullSymbol = nullSymbol;
    }

    public void setConvertUnicode(boolean convertUnicode) {
        this.convertUnicode = convertUnicode;
    }
}

