/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConstraintUtil;
import zigen.plugin.db.core.Messages;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.ui.internal.ITable;

public class TableElementSearcher
extends TableManager {
    public static TableElement findElement(Connection con, TableElement element, boolean isNew) throws Exception {
        TableElement tableElement;
        ResultSet rs = null;
        PreparedStatement pst = null;
        TableElement elements = null;
        TablePKColumn[] pks = null;
        TableIDXColumn[] uidxs = null;
        try {
            ITable table = element.getTable();
            pks = table.getTablePKColumns();
            if (pks == null || pks.length == 0) {
                uidxs = ConstraintUtil.getFirstUniqueIndex(table.getTableUIDXColumns());
            }
            pst = TableElementSearcher.createPreparedStatement(con, element, isNew);
            rs = pst.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            TableColumn[] columns = TableElementSearcher.getTableColumns(meta, element.getTable());
            if (rs.next()) {
                elements = pks != null && pks.length > 0 ? TableElementSearcher.createElement(rs, table, columns, pks, element.getRecordNo()) : TableElementSearcher.createElement(rs, table, columns, uidxs, element.getRecordNo());
            }
            tableElement = elements;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                StatementUtil.close(pst);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(pst);
        return tableElement;
    }

    static PreparedStatement createPreparedStatement(Connection con, TableElement tableElement, boolean isNew) throws Exception {
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        PreparedStatement pst = null;
        IMappingFactory factory = AbstractMappingFactory.getFactory(tableElement.getTable().getDbConfig());
        if (isNew) {
            tableElement.modifyUniqueItems();
        }
        ITable table = tableElement.getTable();
        TableColumn[] uniqueColumns = tableElement.getUniqueColumns();
        Object[] uniqueItems = tableElement.getUniqueItems();
        if (table != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT * FROM ");
            sb.append(String.valueOf(table.getSqlTableName()) + " ");
            int i = 0;
            while (i < uniqueColumns.length) {
                Object uniqueItem = uniqueItems[i];
                TableColumn uniqueColumn = uniqueColumns[i];
                if (i == 0) {
                    sb.append(" WHERE ");
                    sb.append(uniqueColumn.getColumnName());
                    switch (table.getDbConfig().getDbType()) {
                        case 1: {
                            if (uniqueItem == null || nullSymbol.equals(uniqueItem) || "".equals(uniqueItem)) {
                                sb.append(" is null");
                                break;
                            }
                            sb.append(" = ?");
                            break;
                        }
                        default: {
                            if (uniqueItem == null || nullSymbol.equals(uniqueItem)) {
                                sb.append(" is null");
                                break;
                            }
                            sb.append(" = ?");
                            break;
                        }
                    }
                } else {
                    sb.append(" AND ");
                    sb.append(uniqueColumn.getColumnName());
                    switch (table.getDbConfig().getDbType()) {
                        case 1: {
                            if (uniqueItem == null || nullSymbol.equals(uniqueItem) || "".equals(uniqueItem)) {
                                sb.append(" is null");
                                break;
                            }
                            sb.append(" = ?");
                            break;
                        }
                        default: {
                            if (uniqueItem == null || nullSymbol.equals(uniqueItem)) {
                                sb.append(" is null");
                                break;
                            }
                            sb.append(" = ?");
                        }
                    }
                }
                ++i;
            }
            pst = con.prepareStatement(sb.toString());
            int index = 0;
            int i2 = 0;
            while (i2 < uniqueItems.length) {
                Object uniqueItem = uniqueItems[i2];
                TableColumn uniqueColumn = uniqueColumns[i2];
                switch (table.getDbConfig().getDbType()) {
                    case 1: {
                        if (uniqueItem == null || nullSymbol.equals(uniqueItem) || "".equals(uniqueItem)) break;
                        factory.setObject(pst, ++index, uniqueColumn, uniqueItem);
                        break;
                    }
                    default: {
                        if (uniqueItem == null || nullSymbol.equals(uniqueItem)) break;
                        factory.setObject(pst, ++index, uniqueColumn, uniqueItem);
                    }
                }
                ++i2;
            }
            return pst;
        }
        throw new Exception(Messages.getString("TableElementSearcher.17"));
    }
}

