/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zigen.plugin.db.core.StringTokenizer;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.Tokenizer;

public class SQLUtil {
    private static Pattern BIN = Pattern.compile("^BIN\\$.*==\\$0$");
    private static final int MODE_TO_UPPER = 1;
    private static final int MODE_TO_LOWER = 2;

    public static boolean isBinTableForOracle(String str) {
        Matcher matcher = BIN.matcher(str);
        return matcher.matches();
    }

    public static boolean requireDoubleQuote(String str) {
        return SQLUtil.isBinTableForOracle(str) || StringUtil.isNumeric(str) || str.indexOf("-") > 0;
    }

    public static final String encodeQuotation(String str) {
        if (str == null) {
            return str;
        }
        int nLen = str.length();
        StringBuffer sb = new StringBuffer(nLen * 2);
        int i = 0;
        while (i < nLen) {
            char c = str.charAt(i);
            if (c == '\'') {
                sb.append("''");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String encodeEscape(String str) {
        int nLen = str.length();
        StringBuffer sb = new StringBuffer(nLen * 2);
        int i = 0;
        while (i < nLen) {
            char c = str.charAt(i);
            switch (c) {
                case '%': {
                    sb.append("\\%");
                    break;
                }
                case '_': {
                    sb.append("\\_");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isSelect(String sql) throws Exception {
        String s = StringUtil.removeComment(sql);
        s = StringUtil.removeLineComment(s);
        s = StringUtil.removeLeftFullSpace(s);
        if ((s = s.trim()).startsWith("(")) {
            if ((s = s.substring(1)).endsWith(")")) {
                s = s.substring(0, s.length() - 1);
                return SQLUtil.isSelect(s);
            }
            throw new IllegalArgumentException("SQL\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002')'\u304c\u3042\u308a\u307e\u305b\u3093");
        }
        return (s = s.toUpperCase()).startsWith("SELECT") || s.startsWith("SHOW") || s.startsWith("DESCRIBE");
    }

    public static String toUpperCase(String sql) {
        return SQLUtil.toCase(sql, 1);
    }

    public static String toLowerCase(String sql) {
        return SQLUtil.toCase(sql, 2);
    }

    private static String toCase(String sql, int mode) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer t = new StringTokenizer(sql, " ");
        String token = null;
        int indent = 0;
        while ((token = t.nextToken()) != null) {
            if (token.trim().length() == 0) {
                ++indent;
                continue;
            }
            StringBuffer buff = new StringBuffer();
            Tokenizer tokenizer = new Tokenizer(token);
            while (tokenizer.nextToken() != -1) {
                String token2 = tokenizer.getToken();
                String temp = token2.trim();
                if (!(temp.startsWith("'") && temp.endsWith("'") || temp.startsWith("\"") && temp.endsWith("\""))) {
                    token2 = mode == 1 ? token2.toUpperCase() : token2.toLowerCase();
                }
                buff.append(token2);
            }
            if (sb.length() == 0) {
                sb.append(buff.toString());
            } else {
                sb.append(" ");
                sb.append(StringUtil.indent(buff.toString(), indent));
            }
            indent = 0;
        }
        return sb.toString();
    }
}

