/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DefaultXmlManager;
import zigen.plugin.db.core.InputStreamUtil;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.core.SQLHistorySorter;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.util.FileUtil;

public class SQLHistoryManager
extends DefaultXmlManager {
    private int maxSize = 100;
    private List history = null;
    int currentPosition = 0;
    private IPreferenceStore preferenceStore = DbPlugin.getDefault().getPreferenceStore();

    public SQLHistoryManager(IPath path) {
        super(path, "sql_history.xml");
        this.history = this.load();
        if (this.history == null) {
            this.history = new LinkedList();
            this.history.add(new SQLHistory(true));
        }
    }

    public List load() {
        try {
            Object obj = super.loadXml();
            if (obj instanceof List) {
                this.history = (List)obj;
                if (this.history.size() > 0) {
                    this.currentPosition = this.history.size();
                }
                this.history.add(new SQLHistory(true));
                Collections.sort(this.history, new SQLHistorySorter());
                return this.history;
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return null;
    }

    public void save() {
        try {
            TimeWatcher tw = new TimeWatcher();
            tw.start();
            Iterator iter = this.history.iterator();
            while (iter.hasNext()) {
                SQLHistory sql = (SQLHistory)iter.next();
                if (sql.isBlank()) {
                    iter.remove();
                }
                if (sql.isFileMode()) continue;
                this.saveContents(sql);
            }
            super.saveXml(this.history);
            tw.stop();
        }
        catch (IOException e) {
            DbPlugin.log(e);
        }
    }

    public String loadContents(SQLHistory history) {
        String sql = null;
        String folderName = history.getFolderName();
        String fileName = history.getFileName();
        String filePath = String.valueOf(this.file.getParent()) + File.separator + folderName + File.separator + fileName + ".sql";
        File file = new File(filePath);
        sql = file.exists() ? FileUtil.getContents(new File(filePath)) : history.getSql();
        return sql;
    }

    public void saveContents(SQLHistory history) {
        try {
            this.createFolder(history);
            this.createFile(history);
            history.setSql(this.getShortSql(history.getSql()));
            history.setFileMode(true);
            super.saveXml(history);
        }
        catch (IOException e) {
            DbPlugin.log(e);
        }
    }

    String getShortSql(String fullSql) {
        String sql = fullSql;
        if (sql == null) {
            return "";
        }
        if (sql.length() > 100) {
            return String.valueOf(sql.substring(0, 100)) + "...";
        }
        return sql;
    }

    boolean createFolder(SQLHistory history) throws IOException {
        String folderName = history.getFolderName();
        String folderPath = String.valueOf(this.file.getParent()) + File.separator + folderName;
        File f = new File(folderPath);
        if (!f.exists()) {
            return f.mkdir();
        }
        return true;
    }

    void createFile(SQLHistory history) throws IOException {
        String folderName = history.getFolderName();
        String fileName = history.getFileName();
        String filePath = String.valueOf(this.file.getParent()) + File.separator + folderName + File.separator + fileName + ".sql";
        File f = new File(filePath);
        InputStreamUtil.save(f, new StringReader(history.getSql()));
    }

    void removeFile(SQLHistory history) throws IOException {
        String folderName = history.getFolderName();
        String fileName = history.getFileName();
        String filePath = String.valueOf(this.file.getParent()) + File.separator + folderName + File.separator + fileName + ".sql";
        File f = new File(filePath);
        if (f.exists()) {
            f.delete();
        }
        if (f.getParentFile().list().length == 0) {
            f.getParentFile().delete();
        }
    }

    public List getHistory() {
        return this.history;
    }

    public int getHistoryCount() {
        return this.history.size();
    }

    public void clearHistory() {
        this.history = new ArrayList();
        this.currentPosition = 0;
    }

    public void removeOverHistory() throws IOException {
        try {
            this.maxSize = this.preferenceStore.getInt("PreferencePage.MaxHistory");
            while (this.history.size() - 1 > this.maxSize) {
                SQLHistory sh = (SQLHistory)this.history.get(0);
                this.removeFile(sh);
                this.history.remove(0);
                --this.currentPosition;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private boolean isSameHistory(String sql, int position) {
        if (position >= 0) {
            String targetSql;
            TimeWatcher tw = new TimeWatcher();
            tw.start();
            SQLHistory his = (SQLHistory)this.history.get(position);
            String hSql = targetSql = this.loadContents(his);
            String uSql = sql;
            tw.stop();
            return uSql.equals(hSql);
        }
        return false;
    }

    public boolean addHistory(SQLHistory his) throws IOException {
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        boolean isAdd = false;
        String sql = his.getSql();
        this.currentHistory();
        if (!this.isSameHistory(sql, this.currentPosition)) {
            this.saveContents(his);
            this.history.add(his);
            this.currentPosition = this.history.size() - 2;
            isAdd = true;
        }
        Collections.sort(this.history, new SQLHistorySorter());
        this.removeOverHistory();
        tw.stop();
        return isAdd;
    }

    public void remove(SQLHistory sqlHistory) throws IOException {
        this.removeFile(sqlHistory);
        this.history.remove(sqlHistory);
        if (this.currentPosition > 0) {
            --this.currentPosition;
        }
    }

    public SQLHistory currentHistory() {
        return this.history.size() == 0 ? null : (SQLHistory)this.history.get(this.currentPosition);
    }

    public SQLHistory prevHisotry() {
        return this.currentPosition <= 0 ? null : (SQLHistory)this.history.get(--this.currentPosition);
    }

    public SQLHistory nextHisotry() {
        return this.currentPosition == this.history.size() - 1 ? null : (SQLHistory)this.history.get(++this.currentPosition);
    }

    public boolean hasPrevHistory() {
        return this.currentPosition >= 1;
    }

    public boolean hasNextHistory() {
        return this.history.size() - 1 > this.currentPosition;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void modifyCurrentPosition(SQLHistory target) {
        int i = this.history.size() - 1;
        while (i >= 0) {
            SQLHistory sql = (SQLHistory)this.history.get(i);
            if (sql.equals(target)) {
                this.currentPosition = i;
                return;
            }
            --i;
        }
    }
}

