/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.SQLException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.rule.AbstractStatementFactory;
import zigen.plugin.db.core.rule.IStatementFactory;
import zigen.plugin.db.ui.internal.ITable;

public class SQLCreator {
    public static String selectSql(ITable iTable) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(iTable.getSqlTableName());
        return sb.toString();
    }

    public static String createSelectSql(TableElement tableElement, boolean isNew) throws SQLException {
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        if (isNew) {
            tableElement.modifyUniqueItems();
        }
        ITable table = tableElement.getTable();
        IStatementFactory factory = AbstractStatementFactory.getFactory(table.getDbConfig());
        TableColumn[] uniqueColumns = tableElement.getUniqueColumns();
        Object[] uniqueItems = tableElement.getUniqueItems();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(table.getSqlTableName());
        int i = 0;
        while (i < uniqueColumns.length) {
            Object uniqueItem = uniqueItems[i];
            TableColumn col = uniqueColumns[i];
            if (i == 0) {
                sb.append(" WHERE ");
                sb.append(col.getColumnName());
                switch (table.getDbConfig().getDbType()) {
                    case 1: {
                        if (uniqueItem == null || nullSymbol.equals(uniqueItem) || "".equals(uniqueItem)) {
                            sb.append(" is null");
                            break;
                        }
                        sb.append(" = ");
                        sb.append(factory.getString(col.getDataType(), uniqueItems[i]));
                        break;
                    }
                    default: {
                        if (uniqueItem == null || nullSymbol.equals(uniqueItem)) {
                            sb.append(" is null");
                            break;
                        }
                        sb.append(" = ");
                        sb.append(factory.getString(col.getDataType(), uniqueItems[i]));
                        break;
                    }
                }
            } else {
                sb.append(" AND ");
                sb.append(col.getColumnName());
                switch (table.getDbConfig().getDbType()) {
                    case 1: {
                        if (uniqueItem == null || nullSymbol.equals(uniqueItem) || "".equals(uniqueItem)) {
                            sb.append(" is null");
                            break;
                        }
                        sb.append(" = ");
                        sb.append(factory.getString(col.getDataType(), uniqueItems[i]));
                        break;
                    }
                    default: {
                        if (uniqueItem == null || nullSymbol.equals(uniqueItem)) {
                            sb.append(" is null");
                            break;
                        }
                        sb.append(" = ");
                        sb.append(factory.getString(col.getDataType(), uniqueItems[i]));
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String createUpdateSql(ITable table, TableColumn[] updateColumns, Object[] updateItems, TableColumn[] uniqueColumns, Object[] uniqueItems) throws SQLException {
        TableColumn col;
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        IStatementFactory factory = AbstractStatementFactory.getFactory(table.getDbConfig());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(String.valueOf(table.getSqlTableName()) + " ");
        int i = 0;
        while (i < updateColumns.length) {
            col = updateColumns[i];
            if (i == 0) {
                sb.append("SET ");
            } else {
                sb.append(", ");
            }
            sb.append(col.getColumnName());
            sb.append("= ");
            sb.append(factory.getString(col.getDataType(), updateItems[i]));
            ++i;
        }
        i = 0;
        while (i < uniqueColumns.length) {
            col = uniqueColumns[i];
            int type = col.getDataType();
            Object value = uniqueItems[i];
            if (i == 0) {
                sb.append(" WHERE ");
                sb.append(col.getColumnName());
                if (value == null || nullSymbol.equals(value)) {
                    sb.append(" is null ");
                } else {
                    sb.append(" = ");
                    sb.append(factory.getString(type, value));
                }
            } else {
                sb.append(" AND ");
                sb.append(col.getColumnName());
                if (value == null || nullSymbol.equals(value)) {
                    sb.append(" is null ");
                } else {
                    sb.append(" = ");
                    sb.append(factory.getString(type, value));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String createInsertSql(ITable table, TableColumn[] insertColumns, Object[] insertItems) throws Exception {
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        IStatementFactory factory = AbstractStatementFactory.getFactory(table.getDbConfig());
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(String.valueOf(table.getSqlTableName()) + " ");
        sb.append("VALUES (");
        int i = 0;
        while (i < insertColumns.length) {
            TableColumn col = insertColumns[i];
            Object value = insertItems[i];
            if (i > 0) {
                sb.append(",");
            }
            if (value == null || nullSymbol.equals(value)) {
                sb.append("null");
            } else {
                sb.append(factory.getString(col.getDataType(), insertItems[i]));
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String createDeleteSql(ITable table, TableColumn[] uniqueColumns, Object[] uniqueItems) throws Exception {
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        StringBuffer sb = new StringBuffer();
        IStatementFactory factory = AbstractStatementFactory.getFactory(table.getDbConfig());
        sb.append("DELETE FROM ");
        sb.append(String.valueOf(table.getSqlTableName()) + " ");
        int i = 0;
        while (i < uniqueColumns.length) {
            TableColumn col = uniqueColumns[i];
            int type = col.getDataType();
            Object value = uniqueItems[i];
            if (i == 0) {
                sb.append("WHERE ");
                sb.append(uniqueColumns[i].getColumnName());
                if (uniqueItems[i] == null || nullSymbol.equals(uniqueItems[i])) {
                    sb.append(" is null ");
                } else {
                    sb.append(" = ");
                    sb.append(factory.getString(type, value));
                }
            } else {
                sb.append(" AND ");
                sb.append(uniqueColumns[i].getColumnName());
                if (uniqueItems[i] == null || nullSymbol.equals(uniqueItems[i])) {
                    sb.append(" is null ");
                } else {
                    sb.append(" = ");
                    sb.append(factory.getString(type, value));
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

