/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.IOException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipInputStream;

public class DriverSearcherThread
implements Runnable {
    private ClassLoader loader;
    private String[] classpaths;
    private List driverNames;

    public DriverSearcherThread(ClassLoader loader, String[] classpaths) {
        this.loader = loader;
        this.classpaths = classpaths;
    }

    public void run() {
        this.driverNames = this.searchDriver();
    }

    public List searchDriver() {
        ArrayList driverList = new ArrayList();
        ZipInputStream in = null;
        try {
            int i = 0;
            while (i < this.classpaths.length) {
                try {
                    if (this.classpaths[i].endsWith(".class")) {
                        this.addDriverList(driverList, this.classpaths[i]);
                    } else {
                        JarFile jarFile = new JarFile(this.classpaths[i]);
                        Enumeration<JarEntry> e = jarFile.entries();
                        while (e.hasMoreElements()) {
                            JarEntry entry = e.nextElement();
                            this.addDriverList(driverList, entry.getName());
                        }
                    }
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        return driverList;
    }

    private void addDriverList(List driverList, String name) {
        if (name.endsWith(".class")) {
            String cname = name.replaceFirst(".class", "").replaceAll("/", ".");
            try {
                Class<?> clazz = this.loader.loadClass(cname);
                if (!Driver.class.isAssignableFrom(clazz) || Driver.class.equals(clazz)) {
                    return;
                }
                driverList.add(cname);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
            }
            catch (Throwable throwable) {}
        }
    }

    public List getDriverNames() {
        return this.driverNames;
    }
}

