/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.DriverManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Messages;

public class ConnectionManager {
    public static Connection getConnection(IDBConfig config) throws Exception {
        if (config == null) {
            throw new IllegalStateException(Messages.getString("ConnectionManager.0"));
        }
        Connection con = null;
        DriverManager manager = DriverManager.getInstance();
        Driver driver = manager.getDriver(config);
        if (driver != null) {
            con = driver.connect(config.getUrl(), config.getProperties());
            config.setDriverVersion(con.getMetaData().getDriverVersion());
            config.setDatabaseProductVersion(ConnectionManager.getDatabaseProductVersion(con));
            config.setDatabaseProductMajorVersion(ConnectionManager.getDatabaseMajorVersion(con));
            config.setDatabaseProductMinorVersion(ConnectionManager.getDatabaseMinorVersion(con));
            ConnectionManager.checkIsolution(con);
        }
        return con;
    }

    private static String getDatabaseProductVersion(Connection con) {
        String version = "Unknown";
        try {
            version = con.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
        }
        catch (Error error) {}
        return version;
    }

    private static int getDatabaseMajorVersion(Connection con) {
        int version = 0;
        try {
            version = con.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
        }
        catch (Error error) {}
        return version;
    }

    private static int getDatabaseMinorVersion(Connection con) {
        int version = 0;
        try {
            version = con.getMetaData().getDatabaseMinorVersion();
        }
        catch (SQLException sQLException) {
        }
        catch (Error error) {}
        return version;
    }

    private static void checkIsolution(Connection con) {
        try {
            switch (con.getTransactionIsolation()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
                case 8: {
                    break;
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showWarningMessage(e.getMessage());
        }
    }

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                ConnectionManager.rollbackConnection(con);
                con.close();
                con = null;
            }
            catch (SQLException e) {
                DbPlugin.log(e);
            }
        }
    }

    public static void closeConnection(IDBConfig config, Connection con) {
        if (con != null) {
            try {
                ConnectionManager.rollbackConnection(con);
                con.close();
                con = null;
            }
            catch (SQLException e) {
                DbPlugin.log(e);
            }
        }
    }

    public static void shutdown(IDBConfig config) throws Exception {
        DriverManager manager = DriverManager.getInstance();
        try {
            switch (DBType.getType(config)) {
                case 6: {
                    String jdbcDriver = config.getDriverName();
                    if (jdbcDriver.indexOf("EmbeddedDriver") > 0) {
                        Driver driver = manager.getDriver(config);
                        driver.connect("jdbc:derby:;shutdown=true", null);
                    }
                    break;
                }
            }
        }
        finally {
            manager.removeCach(config);
        }
    }

    static void rollbackConnection(Connection con) {
        if (con != null) {
            try {
                if (!con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (SQLException e) {
                DbPlugin.log(e);
            }
        }
    }
}

