/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import kry.sql.format.SqlFormatRule;
import kry.sql.tokenizer.TokenUtil;
import org.eclipse.jface.text.templates.Template;
import zigen.plugin.db.preference.SQLTemplateEditorUI;

public class DbPluginFormatRule {
    private static DbPluginFormatRule instance;
    private SqlFormatRule fRule = new SqlFormatRule();
    private String[] fDefaultKeywords;
    private String[] fDefaultDataTypes;
    private String[] fDefaultFunctions;
    private List fFunctionList;
    private Template[] templates;

    public static synchronized DbPluginFormatRule getInstance() {
        if (instance == null) {
            instance = new DbPluginFormatRule();
        }
        return instance;
    }

    private DbPluginFormatRule() {
        this.fRule.setRemoveEmptyLine(true);
        this.fDefaultFunctions = this.fRule.getFunctions();
        this.fDefaultKeywords = TokenUtil.KEYWORD;
        this.fDefaultDataTypes = TokenUtil.KEYWORD_DATATYPE;
        this.margeTemplate();
    }

    public void margeTemplate() {
        this.fFunctionList = new LinkedList(Arrays.asList(this.fDefaultFunctions));
        this.templates = SQLTemplateEditorUI.getDefault().getTemplateStore().getTemplates("zigen.plugin.db.template.sql.function");
        int i = 0;
        while (i < this.templates.length) {
            Template template = this.templates[i];
            String func = template.getName().toUpperCase();
            if (!this.fFunctionList.contains(func)) {
                this.fFunctionList.add(func);
            }
            ++i;
        }
        this.fRule.setFunctions(this.fFunctionList.toArray(new String[0]));
    }

    public String[] getFunctionNames() {
        return this.fFunctionList.toArray(new String[0]);
    }

    public String[] getKeywordNames() {
        return this.fDefaultKeywords;
    }

    public String[] getDataTypeNames() {
        return this.fDefaultDataTypes;
    }

    public void setDefaultFunction() {
        this.fRule.setFunctions(this.fDefaultFunctions);
    }

    public SqlFormatRule getRule() {
        return this.fRule;
    }

    public void addFunctions(String[] addFunctions) {
        this.fRule.addFunctions(addFunctions);
    }

    public void subtractFunctions(String[] subtractFunctions) {
        this.fRule.subtractFunctions(subtractFunctions);
    }

    public void setFunctions(String[] functions) {
        this.fRule.setFunctions(functions);
    }
}

