package zigen.plugin.db.ui.jobs;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class ChangeColorRecord implements Runnable {

	protected Table table;

	protected Color blue;

	protected Color black;

	protected Color glay;

	protected Color white;

	protected Color lightblue;

	protected int rowIndex;

	protected int columnSize;

	protected String nullSymbol;

	protected ITable tableNode;

	protected Column selectedColumn;

	public ChangeColorRecord(Table table, int rowIndex, int columnSize) {
		this(table, rowIndex, columnSize, null);
	}
	
	public ChangeColorRecord(Table table, int rowIndex, int columnSize, ITable tableNode) {
		this.table = table;
		this.rowIndex = rowIndex;
		this.columnSize = columnSize;
		this.tableNode = tableNode;
	}

	public void run() {
		TableItem item = table.getItem(rowIndex);
		TableElement elem = (TableElement) item.getData();
		TableColumn[] tableColmns = elem.getColumns();

		Color bgcolor;
		if (rowIndex % 2 == 0) {
			bgcolor = white;
		} else {
			bgcolor = lightblue;
		}
		// sԍ̔wiFύX
		item.setBackground(0, bgcolor); // wiF

		if (tableNode == null || selectedColumn == null) {
			// ʏ
			for (int k = 0; k < columnSize - 1; k++) {
				TableColumn tCol = tableColmns[k];
				// JvȂꍇ
				if (nullSymbol.equals(item.getText(k + 1))) {
					item.setForeground(k + 1, blue); // // NULLF
				} else {
					item.setForeground(k + 1, black); // // NULLȊO F()
				}
				item.setBackground(k + 1, bgcolor); // wiF
			}
		} else {
			// JI[h
			ITable targetTable = selectedColumn.getTable();
			for (int k = 0; k < columnSize - 1; k++) {
				TableColumn tCol = tableColmns[k];
				if (targetTable.equals(tableNode) && tCol.getColumnName().equals(selectedColumn.getName())) {
					// Jvꍇ(IԂɂ)
					// item.setForeground(k + 1, white); // F
					item.setForeground(k + 1, black); // F
					item.setBackground(k + 1, glay); // wiF
					table.showColumn(table.getColumn(k + 1)); // J\(XN[)

				} else {
					// JvȂꍇ
					if (nullSymbol.equals(item.getText(k + 1))) {
						item.setForeground(k + 1, blue); // // NULLF
					} else {
						item.setForeground(k + 1, black); // // NULLȊO F()
					}
					item.setBackground(k + 1, bgcolor); // wiF

				}
			}
		}
	}

	public void setSelectedColumn(Column column) {
		this.selectedColumn = column;
	}

	public void setNullSymbol(String nullSymbol){
		this.nullSymbol = nullSymbol;
	}
	
	public void setBlue(Color blue) {
		this.blue = blue;
	}

	public void setBlack(Color black) {
		this.black = black;
	}

	public void setGlay(Color glay) {
		this.glay = glay;
	}

	public void setWhite(Color white) {
		this.white = white;
	}

	public void setLightblue(Color lightblue) {
		this.lightblue = lightblue;
	}

}
