package zigen.plugin.db.ui.contentassist.processor;

import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ContentInfo;
import zigen.plugin.db.ui.contentassist.ProcessorInfo;
import zigen.plugin.db.ui.contentassist.SQLProposalCreator2;
import zigen.plugin.db.ui.views.internal.SQLKeywordScanner;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTTable;
import zigen.sql.parser.ast.ASTUpdateStatement;

public class UpdateProcessor extends DefaultProcessor {

	public UpdateProcessor(List proposals, ProcessorInfo info) {
		super(proposals, info);
	}

	public void createProposals(ASTUpdateStatement st) {

		String[] modifiers = SQLKeywordScanner.SQLKeywords;
		try {
			ContentInfo ci = new ContentInfo(ContentAssistUtil.getIDBConfig());
			TableInfo[] tinfos = ci.getTableInfo(); // 	e[u񃊃Xg擾

			ASTTable table = findASTTable(st);

			switch (currentScope) {

			case SqlParser.SCOPE_UPDATE:
				// e[uXg\
				SQLProposalCreator2.addProposal(proposals, tinfos, pinfo);

				//				if (fromItemCount == 0 || !"".equals(word)) {
				//					// e[uꍇ́Ae[uXg
				//					SQLProposalCreator.addProposal(proposals, infos, word, offset, isAfterPeriod);
				//					modifiers = null;
				//				} else {
				//					// e[u΁Aset̂ݕ\
				//					modifiers = new String[]{
				//						"set"
				//					};
				//				}
				break;

			case SqlParser.SCOPE_SET:
				createColumnProposal(table);
				//				if (fromItemCount == 1) {
				//					if (st.isColumnValuesEditing() || !"".equals(word)) {
				//						// e[uJҏW
				//						Column[] cols = ci.getColumns(st.getTableName());
				//						// 2006/11/24 ZIGEN modify
				//						//Column[] cols = ci.getColumns(ContentAssistUtil.createContentAssistTable(st.getTableName()));
				//						SQLProposalCreator.addProposal(proposals, cols, word, offset, isAfterPeriod);
				//						modifiers = null;
				//
				//					} else if (st.isUpdateValueEditing()) {
				//						// e[uJҏW
				//						modifiers = new String[]{
				//							"select * from"
				//						};
				//					} else {
				//						if (st.isNextEqual()) {
				//							// Jw肳ꂽ=\
				//							modifiers = new String[]{
				//								"="
				//							};
				//						} else {
				//							// e[uJҏW
				//							modifiers = new String[]{
				//								"where"
				//							};
				//						}
				//					}
				//				} else {
				//					modifiers = null;
				//				}
				break;

			case SqlParser.SCOPE_WHERE:
				createColumnProposal(table);

				//				// Whereł́A_ł͏ɃJ\
				//				if (fromItemCount == 1) {
				//					//Column[] cols = ci.getColumns(st.getTableName());
				//					Column[] cols = ci.getColumns(st.getTableName());
				//					// 2006/11/24 ZIGEN modify
				//					//Column[] cols = ci.getColumns(ContentAssistUtil.createContentAssistTable(st.getTableName()));
				//
				//					SQLProposalCreator.addProposal(proposals, cols, word, offset, isAfterPeriod);
				//				}
				break;
			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		} finally {
			// SQLL[[h̓o^
			SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);

		}
	}
}
