/*
 * 쐬: 2006/04/01
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.contentassist;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.parser.util.ASTUtil2;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.plugin.db.preference.CodeAssistPreferencePage;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.preference.SQLTemplateEditorUI;
import zigen.plugin.db.ui.contentassist.processor.DeleteProcessor;
import zigen.plugin.db.ui.contentassist.processor.InsertProcessor;
import zigen.plugin.db.ui.contentassist.processor.SelectProcessor;
import zigen.plugin.db.ui.contentassist.processor.UpdateProcessor;
import zigen.plugin.db.ui.views.internal.SQLContextType;
import zigen.plugin.db.ui.views.internal.SQLKeywordScanner;
import zigen.sql.parser.INode;
import zigen.sql.parser.Node;
import zigen.sql.parser.ast.ASTDeleteStatement;
import zigen.sql.parser.ast.ASTInsertStatement;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTUpdateStatement;

/**
 * SQLContentAssistantProcessorNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/04/01 ZIGEN create.
 * 
 */
public class SQLContentAssistantProcessor2 extends TemplateCompletionProcessor implements IContentAssistProcessor {

	private int current = -1;

	private int scope = -1;

	private INode currentNode;

	private IPreferenceStore preferenceStore;

	public SQLContentAssistantProcessor2() {
		this.preferenceStore = DbPlugin.getDefault().getPreferenceStore();
		this.current = -1;
		this.scope = -1;
		this.currentNode = null;
	}

	private void addTemplateProposal(List proposals, ICompletionProposal[] templates, ProcessorInfo pinfo) {

		if (templates != null) {
			String word = pinfo.getWord();

			if (pinfo.isAfterPeriod())
				word = ""; // sIhŏIĂꍇ""ɒu //$NON-NLS-1$

			int len = word.length();
			for (int i = 0; i < templates.length; i++) {
				ICompletionProposal template = templates[i];
				String str = template.getDisplayString();

				String value = ContentAssistUtil.subString(str, len);
				if (value.compareToIgnoreCase(word) == 0) {
					// ̒ǉ
					proposals.add(template);

				}
			}
		}
	}

	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
		List proposals = new ArrayList();
		try {

			String mode = preferenceStore.getString(CodeAssistPreferencePage.P_SQL_CODE_ASSIST_MODE);
			String demiliter = preferenceStore.getString(SQLEditorPreferencePage.P_SQL_DEMILITER);

			String[] modifiers = SQLKeywordScanner.SQLKeywords;
			IDocument doc = viewer.getDocument();

			ProcessorInfo pinfo = new ProcessorInfo();
			pinfo.setAfterPeriod(ContentAssistUtil.isAfterPeriod(doc, offset));
			pinfo.setOffset(offset);
			pinfo.setWord(ContentAssistUtil.getPreviousWord(doc, offset).toLowerCase());
			pinfo.setWordGroup(ContentAssistUtil.getPreviousWordGroup(doc, offset).toLowerCase());

			if (mode.equals(CodeAssistPreferencePage.MODE_NONE)) {
				return null;

			} else if (mode.equals(CodeAssistPreferencePage.MODE_KEYWORD)) {
				// SQL͂Ȃꍇ
				SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);

			} else if (mode.equals(CodeAssistPreferencePage.MODE_PARSE)) {

				// SQL͂ꍇ
				parseSql(doc, offset, pinfo, demiliter);
				INode st = null;
				if ((st = ASTUtil2.findParent(currentNode, "ASTSelectStatement")) != null) { //$NON-NLS-1$
					SelectProcessor p = new SelectProcessor(proposals, pinfo);
					p.createProposals((ASTSelectStatement) st);

				} else if ((st = ASTUtil2.findParent(currentNode, "ASTInsertStatement")) != null) { //$NON-NLS-1$
					InsertProcessor p = new InsertProcessor(proposals, pinfo);
					p.createProposals((ASTInsertStatement) st);
				} else if ((st = ASTUtil2.findParent(currentNode, "ASTUpdateStatement")) != null) { //$NON-NLS-1$
					UpdateProcessor p = new UpdateProcessor(proposals, pinfo);
					p.createProposals((ASTUpdateStatement) st);
				} else if ((st = ASTUtil2.findParent(currentNode, "ASTDeleteStatement")) != null) { //$NON-NLS-1$
					DeleteProcessor p = new DeleteProcessor(proposals, pinfo);
					p.createProposals((ASTDeleteStatement) st);
				} else {
					SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);
				}
				//				
				// if (viewer instanceof SQLSourceViewer) {
				// SQLSourceViewer sv = (SQLSourceViewer) viewer;
				// IDBConfig config = sv.getDbConfig();
				//
				// if (config != null &&
				// Transaction.getInstance(config).isConneting()) {
				// // SQL͂ꍇ
				// parseSql(doc, offset, pinfo, demiliter);
				// INode st = null;
				// if ((st = ASTUtil2.findParent(currentNode,
				// "ASTSelectStatement")) != null) {
				// SelectProcessor p = new SelectProcessor(proposals, pinfo);
				// p.createProposals((ASTSelectStatement) st);
				//
				// } else if ((st = ASTUtil2.findParent(currentNode,
				// "ASTInsertStatement")) !=
				// null) {
				// InsertProcessor p = new InsertProcessor(proposals, pinfo);
				// p.createProposals((ASTInsertStatement) st);
				// } else if ((st = ASTUtil2.findParent(currentNode,
				// "ASTUpdateStatement")) !=
				// null) {
				// UpdateProcessor p = new UpdateProcessor(proposals, pinfo);
				// p.createProposals((ASTUpdateStatement) st);
				// } else if ((st = ASTUtil2.findParent(currentNode,
				// "ASTDeleteStatement")) !=
				// null) {
				// DeleteProcessor p = new DeleteProcessor(proposals, pinfo);
				// p.createProposals((ASTDeleteStatement) st);
				// } else {
				// SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);
				// }
				// }else{
				// SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);
				//						
				// }

			}
			// ---------------------
			// Templatěǉ
			// ---------------------
			ICompletionProposal[] templates = super.computeCompletionProposals(viewer, offset);
			addTemplateProposal(proposals, templates, pinfo);

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
		// zւ̕ϊ
		return (ICompletionProposal[]) proposals.toArray(new ICompletionProposal[0]);
	}

	private void parseSql(IDocument doc, int offset, ProcessorInfo pinfo, String demiliter) {
		CurrentSql cs = new CurrentSql(doc, offset, demiliter);
		String currentSql = cs.getOffsetSql();
		String allSql = cs.getSql();

		if(allSql == null || "".equals(allSql.trim())) return;
		
		// SQL͂ꍇ
		parseCurrentSql(currentSql);
		parseAllSql(allSql);

		// ȉ̂QSQL͂Ăݒ肷
		pinfo.setCurrentNode(currentNode);
		pinfo.setCurrentScope(scope);

	}

	private void parseCurrentSql(String sql) {
		zigen.sql.parser.ISqlParser parser = null;
		zigen.sql.parser.IVisitor visitor = null;
		try {
			parser = new zigen.sql.parser.SqlParser(sql);
			visitor = new zigen.sql.parser.ASTVisitor();
			INode node = new Node("root"); //$NON-NLS-1$
			parser.parse(node);
			node.accept(visitor, null);
			
			// for debug
			// parser.dump(node);
			
			this.current = visitor.getIndex();
			this.scope = parser.getScope();
		} catch (Exception e) {
			this.current = -1;
			this.scope = -1;
			this.currentNode = null;
		} finally {
			if (parser != null)
				parser = null;
			if (visitor != null)
				visitor = null;
		}
	}

	private void parseAllSql(String sql) {
		
		zigen.sql.parser.ISqlParser parser = null;
		zigen.sql.parser.IVisitor visitor = null;
		// TimeWatcher tw = new TimeWatcher();
		try {
			// tw.start();
			parser = new zigen.sql.parser.SqlParser(sql);
			visitor = new zigen.sql.parser.ASTVisitor();
			INode node = new Node("root"); //$NON-NLS-1$
			parser.parse(node);
			node.accept(visitor, null);
			
			// for debug
			parser.dump(node);
			
			// tw.stop();
			this.currentNode = visitor.findNode(current);
		} catch (Exception e) {
			DbPlugin.log(e);
		} finally {
			if (parser != null)
				parser = null;
			if (visitor != null)
				visitor = null;
		}
	}

	public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
		return null;
	}

	public char[] getCompletionProposalAutoActivationCharacters() {
		return new char[] {
			'.'
		};
	}

	public char[] getContextInformationAutoActivationCharacters() {
		return null;
	}

	public String getErrorMessage() {
		return null;
	}

	public IContextInformationValidator getContextInformationValidator() {
		return null;
	}

	public static String[] SQL_OPERATOR = {
			"=", "<", ">", "IS NULL", "IS NOT NULL", "LIKE", "IN", "EXIST", "(+)", "||", "<=", ">=", "<>", "(", ")", "+", "-", "*", "/"}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$ //$NON-NLS-14$ //$NON-NLS-15$ //$NON-NLS-16$ //$NON-NLS-17$ //$NON-NLS-18$ //$NON-NLS-19$

	protected Template[] getTemplates(String contextTypeId) {
		return SQLTemplateEditorUI.getDefault().getTemplateStore().getTemplates();
	}

	protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
		return SQLTemplateEditorUI.getDefault().getContextTypeRegistry().getContextType(SQLContextType.SQL_CONTEXT_TYPE);
	}

	protected Image getImage(Template template) {
		ImageCacher ic = ImageCacher.getInstance();
		return ic.getImage(DbPlugin.IMG_CODE_TEMPLATE);
	}

	protected String extractPrefix(ITextViewer viewer, int offset) {
		IDocument document = viewer.getDocument();
		int i = offset;
		if (i > document.getLength())
			return ""; //$NON-NLS-1$
		try {
			while (i > 0) {
				char ch = document.getChar(i - 1);
				if (ch != '<' && !Character.isJavaIdentifierPart(ch))
					break;
				i--;
			}
			return document.get(i, offset - i);
		} catch (BadLocationException e) {
			return ""; //$NON-NLS-1$
		}
	}

	protected int getRelevance(Template template, String prefix) {
		if (template.getName().startsWith(prefix)) {
			return 200;
		}
		return 0;
	}
}
