/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.internal.thread.AbstractSQLThread;
import zigen.plugin.db.ui.editors.internal.thread.ModifyTableThread;
import zigen.plugin.db.ui.internal.ITable;

/**
 * RenameTableActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/08 ZIGEN create.
 * 
 */
public class RenameTableAction extends Action implements Runnable {

	private StructuredViewer viewer = null;

	public RenameTableAction(StructuredViewer viewer) {
		this.viewer = viewer;
		this.setText(Messages.getString("RenameTableAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("RenameTableAction.1")); //$NON-NLS-1$

	}

	/**
	 * Actions̏
	 */
	public void run() {

		Object element = (Object) ((StructuredSelection) viewer.getSelection()).getFirstElement();
		try {
			if (element instanceof ITable) {
				ITable table = (ITable) element;

				Shell shell = DbPlugin.getDefault().getShell();
				InputDialog dialog = new InputDialog(shell, Messages.getString("RenameTableAction.2"), Messages.getString("RenameTableAction.3"), table.getName(), null); //$NON-NLS-1$ //$NON-NLS-2$
				int rc = dialog.open();
				if (rc == InputDialog.CANCEL) {
					return;
				}

				String newTableName = dialog.getValue().trim();
				if (!table.getName().equals(newTableName)) {
					String newRemarks = table.getRemarks();

					// łTableύXȂ
					String[] sqls = createSQL(table, newTableName, newRemarks);

					table.setName(newTableName);
					viewer.refresh(table);
				}
			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}
	public String[] createSQL(ITable table, String newTableName, String newRemarks) {
		List list = new ArrayList();
		IDBConfig config = table.getDbConfig();
		ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactory(config, table);

		if (!table.getRemarks().equals(newRemarks)) {
			list.add(factory.createCommentOnTableDDL(newRemarks));
		}
		if (!table.getName().equals(newTableName)) {
			list.add(factory.createRenameTableDDL(newTableName));
		}
		return (String[]) list.toArray(new String[0]);

	}

}
