/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ext.oracle.tablespace;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ext.oracle.tablespace.wizard.CalcTableSpaceWizard;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.views.TableTypeSearchAction;

/**
 * <Oraclep>AnalyzeTableActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/08 ZIGEN create.
 * 
 */
public class CalcTableSpaceWizardAction extends Action {

	// private ISelection selection = null;
	private TreeViewer viewer = null;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public CalcTableSpaceWizardAction(TreeViewer viewer) {
		// this.selection = selection;
		this.viewer = viewer;
		this.setText(Messages.getString("CalcTableSpaceWizardAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("CalcTableSpaceWizardAction.1")); //$NON-NLS-1$
	}

	/**
	 * Actions̏
	 */
	public void run() {
		Object element = (Object) ((StructuredSelection) viewer.getSelection()).getFirstElement();
		if (element instanceof Schema) {
			Schema schema = (Schema) element;
			if (!schema.isExpanded()) {
				// WJtOTrueɂ(e[uvfLbVj
				schema.setExpanded(true);
				// e[uꗗ
				// new TableTypeSearchAction(viewer, schema).run();

				// e[uꗗi񓯊ɂĎsj
				Display display = viewer.getControl().getDisplay();
				display.syncExec(new TableTypeSearchAction(viewer, schema));

			}

		}
		Shell shell = DbPlugin.getDefault().getShell();
		CalcTableSpaceWizard wizard = new CalcTableSpaceWizard(viewer.getSelection());
		WizardDialog dialog = new WizardDialog(shell, wizard);
		dialog.open();
	}

}
