package zigen.plugin.db.diff;

import zigen.plugin.db.ui.internal.TreeLeaf;

public class DDLDiff extends TreeLeaf {

    public static final int TYPE_INCLUDE_ONLY_ORIGN = 10;

    public static final int TYPE_INCLUDE_ONLY_TARGET = 20;

    public static final int TYPE_BOTH_DIFFERENCE = 30;

    public static final int TYPE_BOTH_SAME = 40;

    public static final int TYPE_NOTHING = 99;

    public int getType() {
        if (leftDDL != null && rightDDL != null) {
            if (leftDDL.getDdl().equals(rightDDL.getDdl())) {
                return TYPE_BOTH_SAME;
            } else {
                return TYPE_BOTH_DIFFERENCE;
            }
        } else if (leftDDL == null) {
            return TYPE_INCLUDE_ONLY_TARGET;
        } else if (rightDDL == null) {
            return TYPE_INCLUDE_ONLY_ORIGN;
        } else {
            return TYPE_NOTHING;
        }

    }

    private DDL leftDDL;

    private DDL rightDDL;

    public DDLDiff(DDL leftContent, DDL rightContent) {
        this.leftDDL = leftContent;
        this.rightDDL = rightContent;

        // \p̃e[uݒ
        if (leftContent != null)
            this.name = leftContent.tableName;
        if (rightContent != null)
            this.name = rightContent.tableName;
    }

    public String getName() {
        if (leftDDL != null) {
            return leftDDL.getTableName();
        } else {
            return rightDDL.getTableName();
        }
    }

    public String getLeftDDLString() {
        if (leftDDL != null) {
            return leftDDL.ddl;
        } else {
            return null;
        }
    }

    public String getRightDDLString() {
        if (rightDDL != null) {
            return rightDDL.getDdl();
        } else {
            return null;
        }
    }

    public String getLeftSqlTableName() {
        if (this.leftDDL == null)
            return ""; //$NON-NLS-1$
        StringBuffer sb = new StringBuffer();
        sb.append("["); //$NON-NLS-1$
        sb.append(getLeftDBName());
        sb.append("] "); //$NON-NLS-1$
        sb.append(leftDDL.getSqlTableName());

        return sb.toString();
    }

    public String getRightSqlTableName() {
        if (this.rightDDL == null)
            return ""; //$NON-NLS-1$
        StringBuffer sb = new StringBuffer();
        sb.append("["); //$NON-NLS-1$
        sb.append(getRightDBName());
        sb.append("] "); //$NON-NLS-1$
        sb.append(rightDDL.getSqlTableName());
        return sb.toString();
    }

    public String getLeftDBName() {
        if (this.leftDDL == null)
            return ""; //$NON-NLS-1$
        return leftDDL.getDbName();

    }

    public String getRightDBName() {
        if (this.rightDDL == null)
            return ""; //$NON-NLS-1$
        return rightDDL.getDbName();
    }

    public boolean isComparisonFailure() {
        return leftDDL != null && rightDDL != null;
    }

    public DDL getLeftDDL() {
        return leftDDL;
    }

    public DDL getRightDDL() {
        return rightDDL;
    }

}
