package zigen.plugin.db.core;

import java.util.regex.Pattern;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;

public class StringUtil {

	public static boolean isNumeric(String text) {
		for (int i = 0; i < text.length(); i++) {
			char chr = text.charAt(i);
			if (!(chr >= '0' && chr <= '9')) {
				return false;
			}
		}
		return true;
	}

	/**
	 * 󔒃pfBO(oCg킹j
	 * 
	 * @param value
	 * @param digit
	 * @return
	 */
	public static String padding(String value, int digit) {
		StringBuffer sb = new StringBuffer(value);

		// int len = digit - value.length();
		int len = digit - value.getBytes().length;
		for (int i = 0; i < len; i++) {
			sb.append(" ");
		}
		return sb.toString();
	}

	public static String indent(String value, int digit) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < digit; i++) {
			sb.append(" ");
		}
		sb.append(value);
		return sb.toString();
	}

	public static String rTrim(String str, char trimChar) {
		int cnt = 0;
		for (int i = str.length() - 1; i >= 0; i--) {
			char c = str.charAt(i);
			if (c != trimChar) {
				cnt = i + 1;
				break;
			}
		}
		return str.substring(0, cnt);
	}

	public static String rTrimFullSpace(String str) {
		return rTrim(str, '@'); // ftHg͔p
	}

	public static String lTrimFullSpace(String str) {
		return lTrim(str, '@');
	}

	public static String lTrim(String str, char trimChar) {
		int cnt = str.length();
		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (c != trimChar) {
				cnt = i;
				break;
			}
		}
		return str.substring(cnt);
	}

	/**
	 * 񒆂́u"vGXP[vB
	 * 
	 * @param strSrc
	 *            ̕
	 * @return ϊ̕
	 */
	public static final String encodeDoubleQuotation(String str) {
		return str.replaceAll("\"", "\\\\\"");
	}

	// private static Pattern p = Pattern.compile("/\\*.*?(\\*/|$)");
	// private static Pattern p = Pattern.compile("/\\*.*?(\\*/|\\z)");
	private static Pattern commentPattern = Pattern.compile("/\\*.*?(\\*/|$)", Pattern.DOTALL);

	private static Pattern lineCommentPattern = Pattern.compile("--.*?(\r|\n|$)");

	private static Pattern leftTrimPattern = Pattern.compile("^(@| )+");

	private static Pattern rightTrimPattern = Pattern.compile("(@| )+$");

	public static String removeComment(String s) {
		return commentPattern.matcher(s).replaceAll("");
	}

	public static String removeLineComment(String s) {
		return lineCommentPattern.matcher(s).replaceAll("");
	}

	public static String removeLeftFullSpace(String s) {
		return leftTrimPattern.matcher(s).replaceAll("");
	}

	public static String removerightFullSpace(String s) {
		return rightTrimPattern.matcher(s).replaceAll("");
	}

	/**
	 * sR[hLF(\n)ɓꂷ
	 * 
	 * @param text
	 * @return
	 */
	public static String convertLineSep(String text) {
		text = text.replaceAll("\r\n", "\r");
		text = text.replaceAll("\r", "\n");
		return text;
	}

	/**
	 * sR[hCӂ̃R[hɓꂷ
	 * 
	 * @param text
	 * @return
	 */
	public static String convertLineSep(String text, String demiliter) {
		text = text.replaceAll("\r\n", "\r");
		text = text.replaceAll("\r", "\n");
		text = text.replaceAll("\n", demiliter);
		return text;
	}

	public static void main(String[] args) {

		//System.out.println(StringUtil.convertLineSep("test\r\nte\rst\rtest\ntest\n", DbPluginConstant.LINE_SEP));
		// System.out.println(">>" + lTrimFullSpace(" a") + "<<");
		// System.out.println(">>" + rTrimFullSpace("a ") + "<<");
		// System.out.println(StringUtil.removeComment("AAA"));
		// System.out.println(StringUtil.removeComment("AAA/*BBB*/"));
		// System.out.println(StringUtil.removeComment("AAA/*BBB"));
		// System.out.println(StringUtil.removeComment("AAA/*BBB*/CCC"));
		// System.out.println(StringUtil.removeComment("AAA/*BBB/*CCC*/DDD*/EEE"));
		// System.out.println(StringUtil.removeComment("AAA/a//*BB*B**/CCC"));
		// System.out.println(StringUtil.removeComment("AAA/*BB\nB*/CCC"));
		// System.out.println(StringUtil.removeComment("AAA/*BB\nB*/CCC/*this is
		// test */"));
		// System.out.println(StringUtil.removeComment("AAA/* *BB* */"));
		// System.out.println(StringUtil.removeComment("AAA '/* *BB* */'"));
		// System.out.println(StringUtil.removeLineComment("A --SELECT A FROM
		// T"));
		// System.out.println(StringUtil.removeLineComment("B --SELECT \r\r B
		// FROM T"));
		// System.out.println(StringUtil.removeComment("AAA /* \n HOGEHOGE \n */
		// CCCC"));
		// System.out.println(StringUtil.removeLeftFullSpace(" SELECT * FROM A
		// "));
		// System.out.println(StringUtil.removeLeftFullSpace(" SELECT * FROM A
		// "));
		// System.out.println(StringUtil.removerightFullSpace(" SELECT * FROM A
		// "));
		// System.out.println(StringUtil.removerightFullSpace(" SELECT * FROM A
		// "));
		//System.out.println(StringUtil.encodeDoubleQuotation("123\"123"));
		

	}

}
