/*
 * 쐬: 2005/03/18
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

/**
 * SchemaSearcherNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/18 ZIGEN create.
 * 
 */
public class SchemaSearcher {

	public static String[] execute(IDBConfig config) throws Exception {
		try {
			Connection con = Transaction.getInstance(config).getConnection();
			return execute(con);

		} catch (Exception e) {
			throw e;
		}

	}

	public static String[] execute(Connection con) throws Exception {
		List list = new ArrayList();
		ResultSet rs = null;
		try {
			DatabaseMetaData objMet = con.getMetaData();

			// add ZIGEN XL[}T|[g̃`FbNǉ
			if (!isSupport(con)) {
				return new String[0];
			}

			rs = objMet.getSchemas();

			list = new ArrayList();
			while (rs.next()) {
				list.add(rs.getString("TABLE_SCHEM")); //$NON-NLS-1$
			}

			return (String[]) list.toArray(new String[0]);

		} catch (Exception e) {
			throw e;

		} finally {
			ResultSetUtil.close(rs);
		}

	}

	public static boolean isSupport(IDBConfig config) throws Exception {
		try {
			Connection con = Transaction.getInstance(config).getConnection();
			return isSupport(con);
		} catch (Exception e) {
			throw e;
		}

	}

	public static boolean isSupport(Connection con) {
		try {
			DatabaseMetaData objMet = con.getMetaData();
			return objMet.supportsSchemasInTableDefinitions();

		} catch (Exception e) {
			return false;
		}
	}

}
