/*
 * 쐬: 2005/03/16 쌠: Copyright (c) 2005 ZIGEN CZXFCommon Public License - v 1.0 Fhttp://www.eclipse.org/legal/cpl-v10.html
 */

package zigen.plugin.db.core;

import java.sql.Driver;
import java.util.HashMap;

/**
 * DriverManagerNX. Singletonp^[̗pNX
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/16 ZIGEN create.
 * 
 */
public class DriverManager {
	private static DriverManager _instance;

	private HashMap driverMap = new HashMap();

	/**
	 * PrivatẽRXgN^
	 * 
	 */
	private DriverManager() {
	}

	private String getKey(IDBConfig config) {
		String key;
		if (config.getJdbcType() == 2) {
			// TYPE2̏ꍇ́ADriverŃLbV
			// VersionႢDriver͎Ƃ͂ł܂
			key = config.getDriverName();
		} else {
			// TYPE4̏ꍇ́A_DB{DriverŃLbV
			// VersionႢDrivero^ł悤ɂ邽
			key = config.getDbName() + config.getDriverName();
		}

		return key;
	}

	public void removeCach(IDBConfig config) {
		driverMap.remove(getKey(config));
	}

	/**
	 * CX^X
	 */
	public synchronized static DriverManager getInstance() {
		if (_instance == null) {
			_instance = new DriverManager();
		} else {
		}
		return _instance;

	}

	/**
	 * DriverIuWFNg̎擾
	 * 
	 * @param config
	 * @return
	 * @throws Exception
	 */
	public Driver getDriver(IDBConfig config) throws Exception {
		String key = getKey(config);

		if (driverMap.containsKey(key)) {
			return (Driver) driverMap.get(key);
		} else {
			Driver driver = getDriver(config.getDriverName(), config.getClassPaths());
			driverMap.put(key, driver);
			return driver;
		}

	}

	/**
	 * DriverIuWFNg̎擾
	 * 
	 * @param driverName
	 * @param classpaths
	 * @return
	 * @throws Exception
	 */
	private Driver getDriver(String driverName, String[] classpaths) throws Exception {
		Class driverClass = null;
		PluginClassLoader loader = PluginClassLoader.getClassLoader(classpaths, getClass().getClassLoader());
		try {
			driverClass = loader.loadClass(driverName);
		} catch (ClassNotFoundException e) {
			try {
				driverClass = PluginClassLoader.getSystemClassLoader().loadClass(driverName);
			} catch (ClassNotFoundException ex) {
				throw ex;
			}
		}
		return (Driver) driverClass.newInstance();
	}

}
