require 'darkhall/const'

module DarkHall
	class Rule < StorableObject
		KEYS = %w(
			use_member_classes
		
			common_enemy_ability_bonus
			boss_ability_bonus
			
			trap_difficulty_bonus
			enemy_exp_rate
			enemy_gold_rate
			use_visionary_paper
		)
		
		KEYS.each{|x| attr_reader(x)}
		bool_attr_reader :use_visionary_paper
		
	
		def initialize(params = {})
			init_params(params)
			
			params.each_pair do |key, value|
				instance_variable_set("@#{key}", value)
			end
		end
		
		def init_params(params = {})
			@use_member_classes = [] # 作成可能なクラス（nilで制限無し）
		
			@common_enemy_ability_bonus = 0 # 通常敵の能力値増加
			@boss_ability_bonus = 0         # ボスの能力値増加
			
			@trap_difficulty_bonus = 0 # 罠の難易度増加

			@enemy_exp_rate = 1.0  # 敵から入手できる経験値の倍率
			@enemy_gold_rate = 1.0 # 敵から入手できる金貨の倍率
			
			@use_visionary_paper = false # 「幻紙」を店で購入可能かどうか
		end
		
		def self.create_from_mpac_model(data)
			self.new
		end
	end
	
	class ShortTimeRule < Rule
		def init_params(params = {})
			super
			@enemy_exp_rate = 1.5
			@enemy_gold_rate = 2.0
			
			@use_visionary_paper = true
		end
	end
	
	class NormalRule < Rule
	end
	
	class HardRule < Rule
		def init_params(params = {})
			super
			@common_enemy_ability_bonus = +4
			@boss_ability_bonus = +8
			@trap_difficulty_bonus = +8 # 宝箱のレベルが+4されたのと同じ

			@enemy_exp_rate = 1.0
			@enemy_gold_rate = 0.5
		end
	end
	
	class CustomRule < Rule		
		def self.create_from_mpac_model(data)
			self.new(data)
		end
		
		def dump
			re = {}
			KEYS.each do |key|
				re[key] = instance_variable_get("@#{key}")
			end
		end
	end
end



