#　データ

module DarkHall
	
	
	
	
	class ItemModel < Model
		include GetText
		
	
		attr_accessor :name, :black_name, :price, :effect
		attr_accessor :product_type, :treasure_type, :treasure_rank
		attr_accessor :target_type, :description, :extra_captions
		attr_accessor :message_type
		bool_attr_accessor :instant, :selable, :legendary
		
		
		def init_params
			super
			@name = "[#{@id}]"
			@description = "[#{@id}]"
			@price = 0
			@selable = true
			@effect = nil
			@instant = true
			@target_type = TG_NONE
			@product_type = PD_GOODS
			@treasure_type = TRT::ITEM
			@treasure_rank = nil
			@message_type = nil
			@extra_captions = []
			@legendary = false
		end

		def town_usable?
			(@effect ? @effect.town_usable? : false)
		end
		
		def camp_usable?
			(@effect ? @effect.camp_usable? : false)
		end
		
		def battle_usable?
			(@effect ? @effect.battle_usable? : false)
		end
		
		def sell_price_rate
			0.5
		end
		
		def sell_price
			if @legendary then
				@price * 0.9
			else
				@price * sell_price_rate
			end
		end
	
		def usable_by?(member)
			return true
		end
		
		def item_type_caption
			(instant? ? _('消費アイテム') : _('特殊アイテム'))
		end
		
		def spec_caption_texts
			[]
		end
		
	end
	
	class PotionModel < ItemModel
		def init_params
			super
			@black_name = _("？小瓶")
			@instant = true
			@target_type = TG_MEMBER
			@extra_captions = []
			@description = "????"
			@message_type = :Bottle
			@treasure_type = TRT::POTION
		end
		
		def sell_price_rate
			0.2
		end
	end
	
	class BundleItemModel < ItemModel
		attr_accessor :name_id, :number_max, :name_template
		def init_params
			super
			@number_max = 99
			@name_template = Nn_("%{n}個の%{name}", "%{n}個の%{name}")
	
		end

		def name
			n_(@name_id, 1)
		end

	end
	
	class ArrowModel < BundleItemModel
		attr_accessor :damage_rate
		def init_params
			super
			@name_template = Nn_("%{n}本の%{name}", "%{n}本の%{name}")
			@damage_rate = 1.0
		end
		
		def usable_by?(member)
			member.kind_of?(Archer)
		end

		def item_type_caption
			_('矢')
		end
	end
	
	class BoltModel < BundleItemModel
		def init_params
			super
			@name_template = Nn_("%{n}本の%{name}", "%{n}本の%{name}")
		end
		
		def usable_by?(member)
			!(member.kind_of?(Prayer))
		end

		def item_type_caption
			_('矢')
		end

	end
	

	class MagicStoneModel < ItemModel
		def sell_price_rate
			0.1
		end
		
		
		def init_params
			super
			@instant = true
			@target_type = :none
			@extra_captions = []
			@description = "????"
		end
	end
	
	class SpellBookModel < ItemModel
		attr_accessor :spell_id
	
		def init_params
			super
			@price = 20
			@instant = false
			@spell_id = nil
		end

		def item_type_caption
			_('呪文書')
		end
	end
	
	class KeyModel < ItemModel
		def init_params
			super
			@price = 10
			@instant = false
		end

		def item_type_caption
			_('扉の鍵')
		end
	end
	
	
	
	
	

	class Item < StorableObject
		include InstanceFromModel
		bool_attr_reader :unidentified

		def initialize(data_id)
			super(data_id)
			@unidentified = false
		end
		
		def identify
			@unidentified = false
		end
		
		def unidentify
			@unidentified = true if self.black_name
		end
		
		def identified?
			!(unidentified?)
		end
		
		def price
			data.price.to_i
		end
		
		def sell_price
			(unidentified? ? 0 : data.sell_price.to_i)
		end

		
		def description
			return (unidentified? ? _("(未識別)") : data.description)
		end

		
		def name
			(unidentified ? self.black_name : self.data.name)
		end
		
		def usable_by?(member)
			(unidentified? ? false : super)
		end

		def data
			DB.find_item(@data_id)
		end
		

		def caption_texts
			if identified? then
				[item_type_caption].concat(spec_caption_texts).concat(extra_captions)
			else
				[item_type_caption]
			end
		end


		
		def load_mpac_model(model)
			@data_id = model['data_id']
			@unidentified = model['unidentified']
		end
		
		def dump
			hash = super
			hash['data_id'] = @data_id
			hash['unidentified'] = @unidentified
			return hash
		end
		
		def self.create_from_mpac_model(hash)
			obj = new(hash['data_id'])
			obj.unidentify if hash['unidentified']
			return obj
		end
	end
	
	class BundleItem < Item
		attr_accessor :number
		
		def initialize(data_id, number = 1)
			super(data_id)
			@number = number
		end	
		
		def price
			return (data.price * @number).to_i
		end
		
		def sell_price
			(unidentified? ? 0 : (data.sell_price * @number.to_f).to_i)
		end

		
		def name
			name = n_(self.data.name_id, @number)
			caption = n_(self.name_template, @number)
			return caption.evaluate(:n => @number, :name => name)
			#return "#{@number}#{self.unit}の#{super}"
		end
		
		def dump
			hash = super
			hash['number'] = @number
			return hash
		end
		
		def self.create_from_mpac_model(hash)
			return new(hash['data_id'], hash['number'])
		end

	end
	

	

	
end


