require 'umigame/xunit'
require 'umigame/creator'
require 'umigame/adder'
require 'umigame/sourcecode'
require 'umigame/method'

module Umigame
  class PythonUnit < XUnit
    def PythonUnit.version
      "PyUnit 1.4.1"
    end
    
    def PythonUnit.usage
      print <<"EOB"

#{PythonUnit.version}(--lang python)
  support option: -a, -i, -m, -P, -r, -s
EOB
    end
    
    def PythonUnit.reference
      print <<"EOB"
Assertion Quick Reference
  for #{PythonUnit.version}

fail(msg)
failIf(expr, msg)
failUnless(expr, msg)
  = assert_
failUnlessRaises(excClass, callableObj, *args, **kwargs)
  = assertRaises
failUnlessEqual(first, second, msg)
  = assertEqual
  = assertEquals
failIfEqual(first, second, msg)
  = assertNotEquals
  = failIfEqual
EOB
    end
  end
  
  class PythonUnitMethod < Method
    def initialize(class_name, method_name, statement)
      super(class_name, method_name, "# ", statement)
    end
    
    def decl
     ret = []
      ret.push "def #{name}(self):"
      ret += @statement.split("\n")
      return prefix + ret.join("\n" + prefix) + "\n"
    end
    
    def suite
      return "#{prefix}suite.addTest(#{@classname}(\"#{name}\"))\n"
    end
  end
  
  class PythonUnitSourceCode < SourceCode
    def add_method(methodname, prefix=false, statement=nil)
      unless statement
        statement = "  \"\"\" test description \"\"\"\n  self.fail('not implement yet')"
      end
      method = PythonUnitMethod.new(@class_name, methodname, statement)
      super(method, prefix)
    end
    
    def print
      include = ""
      decl = ""
      suite = ""
      @include.each do |file|
        include +="\n#{file}"
      end
      @method.each do |method|
        decl += "\n" + method.decl
        suite += method.suite
      end
      if has_suite?
        suite = "def suite():\n  suite = unittest.TestSuite()\n# CUPPA:suite=+\n" + suite + "# CUPPA:suite=-\n  return suite"
      else
        suite = "def suite():\n  return unittest.makeSuite(#{@class_name}, 'test')"
      end
      class_end = @class_end.join
      return <<"EOB"
import unittest
# CUPPA:include=+#{include}
# CUPPA:include=-
#{@class_begin.join}# CUPPA:decl=+#{decl}
# CUPPA:decl=-

#{suite}
#{class_end}
EOB
    end
  end
  
  class PythonUnitAdder < Adder
    def initialize
      super("# ", PythonUnitSourceCode.new)
    end
    
    def add_method(method_name)
      @code.add_method(method_name)
    end
    
    protected
    
    def parse_include
      do_parse_include(/(.+)/)
    end
    
    def parse_class_begin
      do_parse_class_begin(/class (.+)\(unittest.TestCase\):/)
    end
    
    def parse_method
      do_parse_method(/^(..)def (.+)\(self\):/)
    end
    
    def parse_suite
      do_parse_suite(/suite = unittest.TestSuite\(\)/, 
        /(#\s|\s\s)\s*suite.addTest\(#{@code.class_name}\(\"(.+)\"\)\)/, 1, 1)
    end
  end
  
  class PythonUnitCreator < Creator
    
    attr_reader :code
    
    def filename(name)
      name + ".py"
    end
    
    def eval_argv
      assert_equal(false, @parser['noregist'], "not support --noregist option")
      @include.collect! do |file|
        'import ' + file
      end
      #parser = ArrayOptParser.new
      #parser.set_option ['--zope', 'z', ArrayOptParser::REQUIRED_ARGUMENT]
      #parser.parse(@parser.other)
      #@testmethod = parser.parse
      #if parser['zope']
      #  
      #end
    end
    
    def write_skeleton
      code = PythonUnitSourceCode.new
      code.class_name = @skeleton
      @include.each do |includefile|
        code.add_include includefile
      end
      code.class_begin.push <<"EOB"

class #{@skeleton}(unittest.TestCase):

  # your stuff...

  def setUp(self):
    # initialize
    pass
  
  def tearDown(self):
    # terminate
    pass

EOB
      code.has_suite = !@prefix

      @testmethod.each do | testcase |
        code.add_new_method testcase
      end


      unless @noregist
        code.class_end.push <<"EOB"

if __name__ == '__main__':
  runner = unittest.TextTestRunner()
  runner.run(suite())
EOB
      end
      return code.print
    end
    
    def write_main
     return <<"EOF"
import unittest
import sys
import getopt
from fnmatch import fnmatchcase
from os import listdir

AllTest = unittest.TestSuite("AllTest")
loader = unittest.TestLoader()
verbosity = 2

usage_msg = """
-h, --help     : show this message
-v, --verbose  : verbose output
-q, --quiet    : minimal output
"""

def usage(msg = None):
  if msg: print msg
  print usage_msg
  sys.exit(2)

try:
  options, args = getopt.getopt(sys.argv[1:],
                                'hHvq', ['help', 'verbose', 'quite'])
  for opt, value in options:
    if opt in ('-h', '-H', '--help'):
      usage()
    if opt in ('-q', '--quiet'):
      verbosity = 0
    if opt in ('-v', '--verbose'):
      verbosity = 2
  
  if 0 == len(args):
    files = listdir(".")
    for file in files:
      if fnmatchcase(file, "test*.py"):
        args.append(file)
  
  for testcase in args:
    try:
      AllTest.addTest(__import__(testcase[0:-3]).suite())
    except ImportError:
      print 'test module not found'
      sys.exit(2)
  
  runner = unittest.TextTestRunner(verbosity=verbosity)
  result = runner.run(AllTest)
  sys.exit(not result.wasSuccessful())

except getopt.error, msg:
  usage(msg)
EOF
    end
  end
end
