module Umigame
  class Method
    
    attr_accessor :comment_out, :statement, :prefix
    attr_reader :classname, :comment
    
    def initialize(classname, methodname, comment, statement="")
      @comment = comment
      @comment_out = false
      @classname = classname
      @statement = statement
      self.name = methodname
    end
    
    def name=(methodname)
      if methodname =~ /^\.(\w+)/
        @name = $1
        @comment_out = true
      else
        @name = methodname
        @comment_out = false
      end
    end
    
    def name
      methodprefix + @name
    end
    
    def methodprefix
      (@prefix ? "test" : "")
    end
    
    def prefix
      @comment_out ? @comment : "  "
    end
    
    def decl
      # hook method
    end
    
    def suite
      # hook method
    end
  end
end

