/*! @file
	File     : mksrclist.cpp
	@brief   : make source-list 
	@author  : ahiru (http://www3.to/ahirus)
	@date $Date: 2002/08/27 08:38:42 $
	$Revision: 1.2 $
	@note : 
*/

static char rcsid[]="$Id: mksrclist.cpp,v 1.2 2002/08/27 08:38:42 smorino Exp $";

#pragma warning(disable:4786)
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <dir>
#include <algorithm>

using namespace std;

void usage(char * fn)
{
	cerr << fn << " " << rcsid << endl;
	cerr << 
	"usage : " << fn << " [-kmnrs] input (ex. - *.cpp)\n"
	"             option                 description\n"
	"             -o [output]        output kind, 0: object, 1:resource\n"
	"             -c [after]         extention change\n"
	"                 ex. -c res --- search input (ex. *.rc) and listup *.res\n";
}

typedef std::vector<std::string> strarg;
bool getflist(strarg & flist,const char * path,string & afterext)
{
	ffblk fh;
	int done=findfirst(path,&fh,0);
	while(!done) {
		std::string cpp=fh.ff_name;
		cpp.replace(cpp.rfind('.')+1,3,afterext);
		flist.push_back(cpp);
		done = findnext(&fh);
	}
	return true;
}

template <class T=std::string>
struct print
{
	print(ostream & os,char * pad,char * tag,char * dir)
		: os_(os) {chgset(pad,tag,dir);}
	void start() {os_<<tag_<<"= \\\n";}
	void end() {os_<<std::endl;}
	void chgset(char * pad,char * tag,char * dir) {
		pad_=pad,tag_=tag,dir_=dir;
	}
	void operator ()(T & obj) {
		os_<< pad_ << "$(" << dir_ << ")\\" << obj << " \\\n";
	}
	std::ostream & os_;
	char * pad_;
	char * tag_;
	char * dir_;
};

int main(int argc,char **argv)
{
	char *cmdname;
	string after_ext="obj";
	int output=0;				// object output

	cmdname=argv[0];
	if(argc>1) {
		argv++;
		do {
			if((*argv)[0]=='-') {
				switch((*argv)[1]) {
				case 'c':
					++argv;
					after_ext=*argv;
					break;
				case 'o':
					++argv;
					output=atoi(*argv);
					break;
				case '-' :
				default:
					usage(cmdname);
					return -1;
				}
			} else break;
			argv++;
		} while (*argv!=NULL);
	} else {
		usage(cmdname);
		return -1;
	} 

	std::stringstream pathlist;
	std::string wk;
	pathlist << "PATHCPP=";
	vector<string> flist;
	while( argv[0] ) {
		getflist(flist,argv[0],after_ext);
		wk=argv[0];

		pathlist << wk.substr(0,wk.rfind('\\')) << ';';
		argv++;
	}
	pathlist << std::endl << std::ends;

	if (output==0) {
		std::cout << pathlist.str().c_str() << std::endl;
		/// release
		print<> prn(cout," ","REL_OBJS","RELEASE_OBJDIR");
		prn.start();
		for_each(flist.begin(),flist.end(),prn);
		prn.end();
		/// debug
		prn.chgset(" ","DEB_OBJS","DEBUG_OBJDIR");
		prn.start();
		for_each(flist.begin(),flist.end(),prn);
		prn.end();
		/// objects for making lib
		prn.chgset(" +","REL_LIBCMD_OBJS","RELEASE_OBJDIR");
		prn.start();
		for_each(flist.begin(),flist.end(),prn);
		prn.end();
		/// objects for making lib
		prn.chgset(" +","DEB_LIBCMD_OBJS","DEBUG_OBJDIR");
		prn.start();
		for_each(flist.begin(),flist.end(),prn);
		prn.end();
	} else if (output==1) {
		std::cout << pathlist.str().c_str() << std::endl;
		print<> prn(cout," ","RESFILE","RESDIR");
		prn.start();
		if (flist.size()>0)
			for_each(flist.begin(),flist.end(),prn);
		else
			std::cout << "+\n";
		prn.end();
	}
	return 0;
}
