# File     : makefile
# Function : makefile for CppUnit with Borland C++
# Author   : ahiru (http://www3.to/ahirus)
# $Date: 2002/08/21 01:03:45 $
# $Revision: 1.2 $

## target
### static lib.
CPPUNIT_RELEASE_LIB=cppunit_bc5.lib
CPPUNIT_DEBUG_LIB=cppunitd_bc5.lib
### DLL
CPPUNIT_RELEASE_DLL=cppunit_bc5_dll.dll
CPPUNIT_DEBUG_DLL=cppunitd_bc5_dll.dll

## CPPUNITV:
## 17: CppUnit v1.7-v1.8.x, 19: v1.9.0/1, 192: v1.9.2
#CPPUNITV=192
CPPUNITV=0
SRCDIR=$(ROOT)\src\cppunit
RELEASE_OBJDIR_static=release_dir
RELEASE_OBJDIR_dll=release_dll
DEBUG_OBJDIR_static=debug_dir
DEBUG_OBJDIR_dll=debug_dll

## compile options
FLAGS_COMMON= -I$(ROOT)\include;$(BCB)\include -jb -j1 -w -c -w-par -w-inl -w-stl -DWIN32
FLAGS_COMMON_static = $(FLAGS_COMMON)
CXXFLAGS_RELEASE_static= $(FLAGS_COMMON_static) -O2 -n$(RELEASE_OBJDIR_static)
CXXFLAGS_DEBUG_static= $(FLAGS_COMMON_static) -v -N -x -xp -n$(DEBUG_OBJDIR_static)

FLAGS_COMMON_dll = $(FLAGS_COMMON) -WM -WD -WR -DCPPUNIT_BUILD_DLL
CXXFLAGS_RELEASE_dll=$(FLAGS_COMMON_dll) -O2 -n$(RELEASE_OBJDIR_dll)
CXXFLAGS_DEBUG_dll=$(FLAGS_COMMON_dll) -v -N -x -xp -n$(DEBUG_OBJDIR_dll)

## link or lib options
LINKSTARTUP= c0d32.obj
LDFLAGS_COMMON_dynamic=-Gn -Gi -Tpd -aa -x
LDFLAGS_RELEASE_dynamic=   $(LDFLAGS_COMMON_dynamic) $(LINKSTARTUP)
LDFLAGS_DEBUG_dynamic=     $(LDFLAGS_COMMON_dynamic) $(LINKSTARTUP)
LDLIBS_RELEASE_dynamic=   import32.lib cw32mti.lib
LDLIBS_DEBUG_dynamic=     import32.lib cw32mti.lib

CXX=bcc32
LINK = tlib /P256
DYN_LINK = ilink32 -L$(BCB)\lib

!if $(CPPUNITV)==17
!include cppunit_17.mak
!elif $(CPPUNITV)==19
!include cppunit_19.mak
!elif $(CPPUNITV)==192
!include cppunit_192.mak
!elif $(CPPUNITV)==0
!include cppunit_cur.mak
!endif

all: debug release debdll reldll

{$(SRCDIR)}.cpp{$(RELEASE_OBJDIR_static)}.obj:
   $(CXX) $(CXXFLAGS_RELEASE_static) $<

{$(SRCDIR)}.cpp{$(RELEASE_OBJDIR_dll)}.obj:
   $(CXX) $(CXXFLAGS_RELEASE_dll) $<

{$(SRCDIR)}.cpp{$(DEBUG_OBJDIR_static)}.obj:
   $(CXX) $(CXXFLAGS_DEBUG_static) $<

{$(SRCDIR)}.cpp{$(DEBUG_OBJDIR_dll)}.obj:
   $(CXX) $(CXXFLAGS_DEBUG_dll) $<

$(DEBUG_OBJDIR_static):
        @if not exist $(DEBUG_OBJDIR_static) (md $(DEBUG_OBJDIR_static)) else echo already exist $(DEBUG_OBJDIR_static) dirctory

$(RELEASE_OBJDIR_static):
        @if not exist $(RELEASE_OBJDIR_static) (md $(RELEASE_OBJDIR_static)) else echo already exist $(RELEASE_OBJDIR_static) dirctory

$(RELEASE_OBJDIR_dll):
        @if not exist $(RELEASE_OBJDIR_dll) (md $(RELEASE_OBJDIR_dll)) else echo already exist $(RELEASE_OBJDIR_dll) dirctory

$(DEBUG_OBJDIR_dll):
        @if not exist $(DEBUG_OBJDIR_dll) (md $(DEBUG_OBJDIR_dll)) else echo already exist $(DEBUG_OBJDIR_dll) dirctory

$(CPPUNIT_RELEASE_LIB): $(REL_OBJS)
        @echo $< building ..
        $(LINK) $< $(REL_LIBCMD_OBJS)

$(CPPUNIT_DEBUG_LIB): $(DEB_OBJS)
        @echo $< building ..
        $(LINK) $< $(DEB_LIBCMD_OBJS)

$(CPPUNIT_RELEASE_DLL): $(REL_DLL_OBJS)
        @echo $< building ..
        $(DYN_LINK) $(LDFLAGS_RELEASE_dynamic) $(REL_DLL_OBJS) , $(CPPUNIT_RELEASE_DLL),,$(LDLIBS_RELEASE_dynamic)

$(CPPUNIT_DEBUG_DLL): $(DEB_DLL_OBJS)
        @echo $< building ..
        $(DYN_LINK) $(LDFLAGS_DEBUG_dynamic) $(DEB_DLL_OBJS) , $(CPPUNIT_DEBUG_DLL),,$(LDLIBS_DEBUG_dynamic)

debug: $(DEBUG_OBJDIR_static) $(CPPUNIT_DEBUG_LIB)

release: $(RELEASE_OBJDIR_static) $(CPPUNIT_RELEASE_LIB)

debdll: $(DEBUG_OBJDIR_dll) $(CPPUNIT_DEBUG_DLL)

reldll: $(RELEASE_OBJDIR_dll) $(CPPUNIT_RELEASE_DLL)

cleandll:
        @if exist $(DEBUG_OBJDIR_dll) (del /q $(DEBUG_OBJDIR_dll)\*)
        @if exist $(DEBUG_OBJDIR_dll) (rmdir /q $(DEBUG_OBJDIR_dll))
        @if exist $(RELEASE_OBJDIR_dll) (del /q $(RELEASE_OBJDIR_dll)\*)
        @if exist $(RELEASE_OBJDIR_dll) (rmdir /q $(RELEASE_OBJDIR_dll))
        @del /q *.lib *.dll
        @del /q *.map *.tds

cleanlib:
        @if exist $(DEBUG_OBJDIR_static) (del /q $(DEBUG_OBJDIR_static)\*)
        @if exist $(DEBUG_OBJDIR_static) (rmdir /q $(DEBUG_OBJDIR_static))
        @if exist $(RELEASE_OBJDIR_static) (del /q $(RELEASE_OBJDIR_static)\*)
        @if exist $(RELEASE_OBJDIR_static) (rmdir /q $(RELEASE_OBJDIR_static))
        @del /q *.map *.tds

clean:
        @if exist $(DEBUG_OBJDIR_static) (del /q $(DEBUG_OBJDIR_static)\*)
        @if exist $(DEBUG_OBJDIR_static) (rmdir /q $(DEBUG_OBJDIR_static))
        @if exist $(RELEASE_OBJDIR_static) (del /q $(RELEASE_OBJDIR_static)\*)
        @if exist $(RELEASE_OBJDIR_static) (rmdir /q $(RELEASE_OBJDIR_static))
        @if exist $(DEBUG_OBJDIR_dll) (del /q $(DEBUG_OBJDIR_dll)\*)
        @if exist $(DEBUG_OBJDIR_dll) (rmdir /q $(DEBUG_OBJDIR_dll))
        @if exist $(RELEASE_OBJDIR_dll) (del /q $(RELEASE_OBJDIR_dll)\*)
        @if exist $(RELEASE_OBJDIR_dll) (rmdir /q $(RELEASE_OBJDIR_dll))
        @del /q *.lib *.dll
        @del /q *.map *.tds

