/*
 * tcuppa.c
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "strvec.h"

int main(int argc, char* argv[]) {
  strvec* includes;
  strvec* cases;
  char*   group;
  FILE*   file;
  char    path[256];
  int     i;

  includes = strvec_new(4);
  cases    = strvec_new(4);
  group    = 0;

  for ( i = 1; i < argc; ++i ) {
    char* arg = argv[i];
    if ( strchr(arg,'.') ) {
      strvec_push_back(includes, arg);
    } else if ( group ) {
      strvec_push_back(cases,arg);
    } else {
      group = arg;
    }
  }

  if ( !group ) {
    return 0;
  }

  strcpy(path, group);
  strcat(path, ".c");
  file = fopen(path, "rt");
  if ( file ) {
    fclose(file);
    fprintf(stderr, "%s already exists. (skip)\n", path);
    return 0;
  }

  file = fopen(path, "wt");
  if ( !file ) {
    fprintf(stderr, "%s open failure.\n", path);
    return 1;
  }

  fprintf(file, "#include <CUnit.h>\n"
                "#include <TestDB.h>\n\n");
  fprintf(file, "/*CUPPA:include=+ */\n");
  for ( i = 0; i < strvec_size(includes); ++i ) {
    fprintf(file, "#include \"%s\"\n", strvec_get(includes,i));
  }
  fprintf(file, "/*CUPPA:include=- */\n\n");
  fprintf(file, "\n"
              "static int init(void) {\n"
              "  /* initialize */\n"
              "  return 0;\n"
              "}\n\n"
              "static int term(void) {\n"
              "  /* terminate */\n"
              "  return 0;\n"
              "}\n\n");
  fprintf(file, "/*CUPPA:impl=+ */\n");
  for ( i = 0; i < strvec_size(cases); ++i ) {
    fprintf(file, "static void %s(void) {\n"
                  "  ASSERT(!\"no implementation\");\n"
                  "}\n\n",
                  strvec_get(cases, i));
  }
  fprintf(file, "/*CUPPA:impl=- */\n");
  fprintf(file, "void %s(void) {\n"
                "  TestGroup* group = add_test_group(\"%s\", init, term);\n",
                group, group);
  fprintf(file, "/*CUPPA:suite=+ */\n");
  for ( i = 0; i < strvec_size(cases); ++i ) {
    fprintf(file, "  add_test_case(group, \"%s\", %s);\n",
                  strvec_get(cases, i), strvec_get(cases, i));
  }
  fprintf(file, "/*CUPPA:suite=- */\n");
  fprintf(file, "}\n");

  fclose(file);

  strvec_del(includes);
  strvec_del(cases);

  return 0;

}
