/*
 * bcuppa.c
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "strvec.h"

int main(int argc, char* argv[]) {
  strvec* groups;
  char*   name;
  FILE*   file;
  char    path[256];
  int     i;

  groups = strvec_new(4);
  name   = 0;

  for ( i = 1; i < argc; ++i ) {
    char arg[256];
    strcpy(arg,argv[i]);
    if ( strchr(arg,'.') ) {
      *strchr(arg,'.') = '\0';
      strvec_push_back(groups, arg);
    } else if ( name ) {
      strvec_push_back(groups,arg);
    } else {
      name = argv[i];
    }
  }

  if ( !name ) {
    return 0;
  }

  strcpy(path, name);
  strcat(path, ".c");

  file = fopen(path, "wt");
  if ( !file ) {
    fprintf(stderr, "%s open failure.\n", path);
    return 1;
  }

  fprintf(file, "#include <Console.h>\n");
  fprintf(file, "/*CUPPA:groupdecl=+ */\n");
  for ( i = 0; i < strvec_size(groups); ++i ) {
    fprintf(file, "extern void %s(void);\n", strvec_get(groups,i));
  }
  fprintf(file, "/*CUPPA:groupdecl=- */\n");
  fprintf(file, "\n"
                "int main() {\n"
                "  initialize_registry();\n");
  fprintf(file, "/*CUPPA:groupreg=+ */\n");
  for ( i = 0; i < strvec_size(groups); ++i ) {
    fprintf(file, "  %s();\n", strvec_get(groups,i));
  }
  fprintf(file, "/*CUPPA:groupreg=- */\n");
  fprintf(file, "  console_run_tests();\n"
                "  cleanup_registry();\n"
                "  return 0;\n"
                "}\n");

  fclose(file);

  strvec_del(groups);

  return 0;

}
