/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: PointLengthTest.java,v 1.0 2005/08/25 2:22:40 Teletha Exp $
 */
public class PointLengthTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.value.PointLength.CSSptLength(float, CSSValue)'
     */
    public void testCSSptLengthFloatValue1() {
        PointLength length = new PointLength(12, null);

        assertEquals("12pt", length.toString());
        assertEquals("12pt", length.getCssText());
        assertEquals("12", length.getStringValue());
        assertEquals(12, length.getIntegerValue());
        assertEquals(12, length.getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.PointLength.CSSptLength(float, CSSValue)'
     */
    public void testCSSptLengthFloatValue2() {
        PointLength length = new PointLength(12.4f, null);

        assertEquals("12.4pt", length.toString());
        assertEquals("12.4pt", length.getCssText());
        assertEquals("12.4", length.getStringValue());
        assertEquals(12, length.getIntegerValue());
        assertEquals(12.4f, length.getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.PointLength.CSSptLength(float, CSSValue)'
     */
    public void testCSSptLengthFloatValue3() {
        PointLength length = new PointLength(12.5555f, null);

        assertEquals("12.5555pt", length.toString());
        assertEquals("12.5555pt", length.getCssText());
        assertEquals("12.5555", length.getStringValue());
        assertEquals(13, length.getIntegerValue());
        assertEquals(12.5555f, length.getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.PointLength.CSSptLength(String, CSSValue)'
     */
    public void testCSSptLengthStringValue1() {
        PointLength length = new PointLength("12", null);

        assertEquals("12pt", length.toString());
        assertEquals("12pt", length.getCssText());
        assertEquals("12", length.getStringValue());
        assertEquals(12, length.getIntegerValue());
        assertEquals(12, length.getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.PointLength.CSSptLength(String, CSSValue)'
     */
    public void testCSSptLengthStringValue2() {
        PointLength length = new PointLength("12.4", null);

        assertEquals("12.4pt", length.toString());
        assertEquals("12.4pt", length.getCssText());
        assertEquals("12.4", length.getStringValue());
        assertEquals(12, length.getIntegerValue());
        assertEquals(12.4f, length.getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.PointLength.CSSptLength(String, CSSValue)'
     */
    public void testCSSptLengthStringValue3() {
        PointLength length = new PointLength("12.5555", null);

        assertEquals("12.5555pt", length.toString());
        assertEquals("12.5555pt", length.getCssText());
        assertEquals("12.5555", length.getStringValue());
        assertEquals(13, length.getIntegerValue());
        assertEquals(12.5555f, length.getFloatValue(), 0);
    }
}
