/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import junit.framework.TestCase;

import org.trix.cuery.property.SimpleProperty;
import org.trix.cuery.value.CSSColor;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.Identifier;
import org.trix.cuery.value.PointLength;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BorderDefinitionTest.java,v 1.0 2005/08/30 17:34:16 Teletha Exp $
 */
public class BorderDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderDefinition.parseValue(CSSValue)'
     */
    public void testParse1() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new PointLength(2, value);
        new CSSColor(0, 0, 0, value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border", value, false);

        assertEquals("#000000", property.getValueAsString("border-top-color"));
        assertEquals("#000000", property.getValueAsString("border-right-color"));
        assertEquals("#000000", property.getValueAsString("border-bottom-color"));
        assertEquals("#000000", property.getValueAsString("border-left-color"));

        assertEquals("solid", property.getValueAsString("border-top-style"));
        assertEquals("solid", property.getValueAsString("border-right-style"));
        assertEquals("solid", property.getValueAsString("border-bottom-style"));
        assertEquals("solid", property.getValueAsString("border-left-style"));

        assertEquals("2", property.getValueAsString("border-top-width"));
        assertEquals("2", property.getValueAsString("border-right-width"));
        assertEquals("2", property.getValueAsString("border-bottom-width"));
        assertEquals("2", property.getValueAsString("border-left-width"));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderDefinition.parseValue(CSSValue)' whether
     * the order of the css values is independent or not.
     */
    public void testParse2() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new CSSColor(0, 0, 0, value);
        new PointLength(2, value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border", value, false);

        assertEquals("#000000", property.getValueAsString("border-top-color"));
        assertEquals("#000000", property.getValueAsString("border-right-color"));
        assertEquals("#000000", property.getValueAsString("border-bottom-color"));
        assertEquals("#000000", property.getValueAsString("border-left-color"));

        assertEquals("solid", property.getValueAsString("border-top-style"));
        assertEquals("solid", property.getValueAsString("border-right-style"));
        assertEquals("solid", property.getValueAsString("border-bottom-style"));
        assertEquals("solid", property.getValueAsString("border-left-style"));

        assertEquals("2", property.getValueAsString("border-top-width"));
        assertEquals("2", property.getValueAsString("border-right-width"));
        assertEquals("2", property.getValueAsString("border-bottom-width"));
        assertEquals("2", property.getValueAsString("border-left-width"));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderDefinition.parseValue(CSSValue)' whether
     * 'inherit' identifier is acceptable or not.
     */
    public void testParse3() {
        // test inherit
        CSSValue value = new Identifier("inherit", null);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border", value, false);

        assertEquals("inherit", property.getValueAsString("border-top-color"));
        assertEquals("inherit", property.getValueAsString("border-right-color"));
        assertEquals("inherit", property.getValueAsString("border-bottom-color"));
        assertEquals("inherit", property.getValueAsString("border-left-color"));

        assertEquals("inherit", property.getValueAsString("border-top-style"));
        assertEquals("inherit", property.getValueAsString("border-right-style"));
        assertEquals("inherit", property.getValueAsString("border-bottom-style"));
        assertEquals("inherit", property.getValueAsString("border-left-style"));

        assertEquals("inherit", property.getValueAsString("border-top-width"));
        assertEquals("inherit", property.getValueAsString("border-right-width"));
        assertEquals("inherit", property.getValueAsString("border-bottom-width"));
        assertEquals("inherit", property.getValueAsString("border-left-width"));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderDefinition.parseValue(CSSValue)' with a
     * invalid value.
     */
    public void testParse4() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new CSSColor(1, 1, 1, value);
        new Identifier("double", value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border", value, false);

        assertNull(property.getValueAsString("border-top-color"));
        assertNull(property.getValueAsString("border-right-color"));
        assertNull(property.getValueAsString("border-bottom-color"));
        assertNull(property.getValueAsString("border-left-color"));

        assertNull(property.getValueAsString("border-top-style"));
        assertNull(property.getValueAsString("border-right-style"));
        assertNull(property.getValueAsString("border-bottom-style"));
        assertNull(property.getValueAsString("border-left-style"));

        assertNull(property.getValueAsString("border-top-width"));
        assertNull(property.getValueAsString("border-right-width"));
        assertNull(property.getValueAsString("border-bottom-width"));
        assertNull(property.getValueAsString("border-left-width"));
    }
}
