/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import junit.framework.TestCase;

import org.trix.cuery.value.EMLength;
import org.trix.cuery.value.PixelLength;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: SimplePropertyDefinitionTest.java,v 1.0 2005/09/20 6:23:51 Teletha Exp $
 */
public class SimplePropertyDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.SimplePropertyDefinition.computeEMLength(EMLength,
     * Property, Property)'
     */
    public void testComputeEMLength() {
        EMLength value = new EMLength(1);
        SimpleProperty property = new SimpleProperty();
        property.setProperty("font-size", new PixelLength(100), false);
        property.setProperty("width", value, false);

        PropertyDefinition definition = PropertyRegistry.getDefinition("width");
        assertEquals("100px", definition.computeEMLength(value, property, null).getCssText());
    }
}
