/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import org.w3c.css.sac.CSSException;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CountersFunction.java,v 1.0 2005/08/09 22:46:56 Teletha Exp $
 */
public class CountersFunction extends CSSFunction implements Counter {

    /**
     * Create CountersFunction instance.
     * 
     * @param expression A expression of this counter function.
     * @param previous A previous value of this value.
     */
    public CountersFunction(CSSValue expression, CSSValue previous) {
        super("counters", expression, previous);

        // check length
        if (expression.getLength() != 3) {
            throw new CSSException("This expression is invalid fo this counters function.");
        }
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        return SAC_COUNTERS_FUNCTION;
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_COUNTER;
    }

    /**
     * @see org.trix.cuery.value.AbstractCSSValue#getCounterValue()
     */
    public Counter getCounterValue() throws DOMException {
        return this;
    }

    /**
     * @see org.w3c.dom.css.Counter#getIdentifier()
     */
    public String getIdentifier() {
        return params.item(0).toString();
    }

    /**
     * @see org.w3c.dom.css.Counter#getListStyle()
     */
    public String getListStyle() {
        return null;
    }

    /**
     * @see org.w3c.dom.css.Counter#getSeparator()
     */
    public String getSeparator() {
        return params.get(2).getStringValue();
    }

}
