/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AttrFunction.java,v 1.01 2005/9/10 12:02:49 Teletha Exp $
 */
public class AttrFunction extends CSSFunction {

    /**
     * Create AttrFunction instance.
     * 
     * @param expression A expression of this attr function.
     * @param previous A previous value of this value.
     */
    public AttrFunction(CSSValue expression, CSSValue previous) {
        super("attr", expression, previous);
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        return SAC_ATTR;
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_ATTR;
    }
}
