/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: I18nUtil.java,v 1.0 2005/09/10 14:57:11 Teletha Exp $
 */
public final class I18nUtil {

    /** The resource bundle cache. */
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("message");

    /**
     * Avoid creating I18nUtil instance.
     */
    private I18nUtil() {
    }

    /**
     * Get localized message with no arguments.
     * 
     * @param key A key name.
     * @return A localized message.
     */
    public static String getText(String key) {
        return BUNDLE.getString(key);
    }

    /**
     * Get localized message with one argument.
     * 
     * @param key A key name.
     * @param argument0 The first argument.
     * @return A localized message.
     */
    public static String getText(String key, String argument0) {
        String message = BUNDLE.getString(key);
        return MessageFormat.format(message, new Object[] {argument0});
    }

    /**
     * Get localized message with two arguments.
     * 
     * @param key A key name.
     * @param argument0 The first argument.
     * @param argument1 The second argument.
     * @return A localized message.
     */
    public static String getText(String key, String argument0, String argument1) {
        String message = BUNDLE.getString(key);
        return MessageFormat.format(message, new Object[] {argument0, argument1});
    }
}
