/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import java.util.Map;

import org.trix.cuery.property.ShorthandPropertyDefinition;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ListStyleDefinition.java,v 1.0 2005/09/01 5:40:12 Teletha Exp $
 */
public class ListStyleDefinition extends ShorthandPropertyDefinition {

    /**
     * @see org.trix.cuery.property.ShorthandPropertyDefinition#validate(java.util.Map)
     */
    protected Map validate(Map result) {
        Object object = result.get("list-style-type");

        if (object == null) {
            return null;
        }

        if (object.toString().equals("none")) {
            result.put("list-style-image", object);
        }
        return result;
    }
}
