/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import java.util.HashMap;
import java.util.Map;

import org.trix.cuery.property.Property;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.Identifier;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BackgroundHorizontalPositionDefinition.java,v 1.01 2005/09/10 20:55:47 Teletha Exp $
 */
public class BackgroundHorizontalPositionDefinition extends PropertyDefinition {

    /**
     * @see org.trix.cuery.property.PropertyDefinition#parse(org.trix.cuery.value.CSSValue)
     */
    public Map parse(CSSValue value) {
        // excluding identifier 'center' which is acceptable in 'background-vertical-position'
        // property
        if (!value.getCssText().equals("center")) {
            return super.parse(value);
        }

        // validate the next css value for 'background-horizontal-position' property
        CSSValue next = value.getNextValue();
        Map result = super.parse(next);

        if (result == null) {
            return super.parse(value);
        }

        // the next value is valid for 'background-horizontal-position' property
        // current value is treated as 'background-vertical-position' property
        result = new HashMap(2);
        result.put("background-horizontal-position", next);
        result.put("background-vertical-position", value);
        return result;
    }

    /**
     * @see org.trix.cuery.property.PropertyDefinition#computeIdentifier(org.trix.cuery.value.Identifier,
     *      org.trix.cuery.property.Property, org.trix.cuery.property.Property)
     */
    protected CSSValue computeIdentifier(Identifier identifier, Property property, Property parent) {
        String string = identifier.getCssText();

        if (string.equals("left")) {
            return new CSSPercentage(0, null);
        } else if (string.equals("center")) {
            return new CSSPercentage(50, null);
        } else if (string.equals("right")) {
            return new CSSPercentage(100, null);
        } else {
            return null;
        }
    }

}
