/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: PropertyUtil.java,v 1.0 2005/09/26 21:44:07 Teletha Exp $
 */
public final class PropertyUtil {

    /**
     * Avoid creating PropertyUtil instance.
     */
    private PropertyUtil() {
    }

    /**
     * Implementation of min and max algorithm.
     * 
     * @param length A lenght.
     * @param min A min length. This value must be non-negative.
     * @param max A max length. This value must be non-negative.
     * @return A computed length.
     */
    public static int computeMinMaxAlgorithm(int length, int min, int max) {
        // If the computed value of 'min-length' is greater than the value of 'max-length',
        // 'max-length' is set to the value of 'min-length'.
        if (-1 < max && max < min) {
            max = min;
        }

        // If the computed width is greater than 'max-width', the rules above are applied again, but
        // this time using the value of 'max-length' as the specified value for 'length'.
        if (-1 < max && max < length) {
            return computeMinMaxAlgorithm(max, min, max);
        }

        // If the computed width is smaller than 'min-length', the rules above are applied again,
        // but
        // this time using the value of 'min-length' as the specified value for 'length'.
        if (-1 < min && length < min) {
            return computeMinMaxAlgorithm(min, min, max);
        }
        return length;
    }

}
