/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import java.util.Set;

import org.trix.cuery.util.DOMUtil;

import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @TODO more filtable
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ChildFilter.java,v 1.0 2005/07/29 11:59:43 Teletha Exp $
 */
public class ChildFilter extends AbstractProcessingFilter implements DescendantSelector {

    /**
     * Create ChildFilter instance.
     * 
     * @param parent A parent selector.
     * @param simpleSelector A current selector.
     */
    public ChildFilter(Selector parent, SimpleSelector simpleSelector) {
        super(parent, simpleSelector);
    }

    /**
     * @see org.trix.cuery.filter.ProcessingFilter#process(java.util.Set, org.w3c.dom.Element)
     */
    public void process(Set container, Element source) {
        container.addAll(DOMUtil.retrieveElements(source, current, false));
    }

    /**
     * @see org.w3c.css.sac.Selector#getSelectorType()
     */
    public short getSelectorType() {
        return SAC_CHILD_SELECTOR;
    }

    /**
     * @see org.w3c.css.sac.DescendantSelector#getAncestorSelector()
     */
    public Selector getAncestorSelector() {
        return getSelector();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return parent + " > " + current;
    }
}
