/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.value;

import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.AbstractCSSValue;
import org.trix.cuery.value.CSSValue;

public class CSSPercentage
extends AbstractCSSValue {
    public static final String UNIT = "%";

    public CSSPercentage(float percentage) {
        this(percentage, null);
    }

    public CSSPercentage(String percentage) {
        this(percentage, null);
    }

    public CSSPercentage(float percentage, CSSValue previous) {
        super(previous);
        this.stringValue = CSSUtil.displayFloat(percentage);
        this.floatValue = percentage;
    }

    public CSSPercentage(String percentage, CSSValue previous) {
        super(previous);
        if (percentage.endsWith(UNIT)) {
            percentage = percentage.substring(0, percentage.length() - 1);
        }
        this.stringValue = percentage;
        this.floatValue = Float.parseFloat(percentage);
    }

    public String getDimensionUnitText() {
        return UNIT;
    }

    public short getLexicalUnitType() {
        return 23;
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public short getPrimitiveType() {
        return 2;
    }

    public String getCssText() {
        return String.valueOf(this.stringValue) + this.getDimensionUnitText();
    }
}

