/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.value;

import java.awt.Color;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Map;
import org.trix.cuery.value.AbstractCSSValue;
import org.trix.cuery.value.CSSNumber;
import org.trix.cuery.value.CSSValue;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class CSSColor
extends AbstractCSSValue
implements RGBColor {
    private static final Map DEFINED_COLOR = new HashMap(173);
    protected String actual;
    protected int red = 0;
    protected int green = 0;
    protected int blue = 0;

    static {
        DEFINED_COLOR.put("aliceblue", new int[]{240, 248, 255});
        DEFINED_COLOR.put("antiquewhite", new int[]{250, 235, 215});
        int[] nArray = new int[3];
        nArray[1] = 255;
        nArray[2] = 255;
        DEFINED_COLOR.put("aqua", nArray);
        DEFINED_COLOR.put("aquamarine", new int[]{127, 255, 212});
        DEFINED_COLOR.put("azure", new int[]{240, 255, 255});
        DEFINED_COLOR.put("beige", new int[]{245, 245, 220});
        DEFINED_COLOR.put("bisque", new int[]{255, 228, 196});
        DEFINED_COLOR.put("black", new int[3]);
        DEFINED_COLOR.put("blanchedalmond", new int[]{255, 235, 205});
        int[] nArray2 = new int[3];
        nArray2[2] = 255;
        DEFINED_COLOR.put("blue", nArray2);
        DEFINED_COLOR.put("blueviolet", new int[]{138, 43, 226});
        DEFINED_COLOR.put("brown", new int[]{165, 42, 42});
        DEFINED_COLOR.put("burlywood", new int[]{222, 184, 135});
        DEFINED_COLOR.put("cadetBlue", new int[]{95, 158, 160});
        int[] nArray3 = new int[3];
        nArray3[0] = 127;
        nArray3[1] = 255;
        DEFINED_COLOR.put("chartreuse", nArray3);
        DEFINED_COLOR.put("chocolate", new int[]{210, 105, 30});
        DEFINED_COLOR.put("coral", new int[]{255, 127, 80});
        DEFINED_COLOR.put("cornflowerblue", new int[]{100, 149, 237});
        DEFINED_COLOR.put("cornsilk", new int[]{255, 248, 220});
        DEFINED_COLOR.put("crimson", new int[]{220, 20, 60});
        int[] nArray4 = new int[3];
        nArray4[1] = 255;
        nArray4[2] = 255;
        DEFINED_COLOR.put("cyan", nArray4);
        int[] nArray5 = new int[3];
        nArray5[2] = 139;
        DEFINED_COLOR.put("darkblue", nArray5);
        int[] nArray6 = new int[3];
        nArray6[1] = 139;
        nArray6[2] = 139;
        DEFINED_COLOR.put("darkcyan", nArray6);
        DEFINED_COLOR.put("darkgoldenrod", new int[]{184, 134, 11});
        DEFINED_COLOR.put("darkgray", new int[]{169, 169, 169});
        int[] nArray7 = new int[3];
        nArray7[1] = 100;
        DEFINED_COLOR.put("darkgreen", nArray7);
        DEFINED_COLOR.put("darkkhaki", new int[]{189, 183, 107});
        int[] nArray8 = new int[3];
        nArray8[0] = 139;
        nArray8[2] = 139;
        DEFINED_COLOR.put("darkmagenta", nArray8);
        DEFINED_COLOR.put("darkolivegreen", new int[]{85, 107, 47});
        int[] nArray9 = new int[3];
        nArray9[0] = 255;
        nArray9[1] = 140;
        DEFINED_COLOR.put("darkorange", nArray9);
        DEFINED_COLOR.put("darkorchid", new int[]{153, 50, 204});
        int[] nArray10 = new int[3];
        nArray10[0] = 139;
        DEFINED_COLOR.put("darkred", nArray10);
        DEFINED_COLOR.put("darksalmon", new int[]{233, 150, 122});
        DEFINED_COLOR.put("darkseagreen", new int[]{143, 188, 143});
        DEFINED_COLOR.put("darkslateblue", new int[]{72, 61, 139});
        DEFINED_COLOR.put("darkslategray", new int[]{47, 79, 79});
        DEFINED_COLOR.put("darkslategrey", new int[]{47, 79, 79});
        int[] nArray11 = new int[3];
        nArray11[1] = 206;
        nArray11[2] = 209;
        DEFINED_COLOR.put("darkturquoise", nArray11);
        int[] nArray12 = new int[3];
        nArray12[0] = 148;
        nArray12[2] = 211;
        DEFINED_COLOR.put("darkviolet", nArray12);
        DEFINED_COLOR.put("deeppink", new int[]{255, 20, 147});
        int[] nArray13 = new int[3];
        nArray13[1] = 191;
        nArray13[2] = 255;
        DEFINED_COLOR.put("deepskyblue", nArray13);
        DEFINED_COLOR.put("dimgray", new int[]{105, 105, 105});
        DEFINED_COLOR.put("dimgrey", new int[]{105, 105, 105});
        DEFINED_COLOR.put("dodgerblue", new int[]{30, 144, 255});
        DEFINED_COLOR.put("firebrick", new int[]{178, 34, 34});
        DEFINED_COLOR.put("floralwhite", new int[]{255, 250, 240});
        DEFINED_COLOR.put("forestgreen", new int[]{34, 139, 34});
        int[] nArray14 = new int[3];
        nArray14[0] = 255;
        nArray14[2] = 255;
        DEFINED_COLOR.put("fuchsia", nArray14);
        DEFINED_COLOR.put("gainsboro", new int[]{220, 220, 220});
        DEFINED_COLOR.put("ghostwhite", new int[]{248, 248, 255});
        int[] nArray15 = new int[3];
        nArray15[0] = 255;
        nArray15[1] = 215;
        DEFINED_COLOR.put("gold", nArray15);
        DEFINED_COLOR.put("goldenrod", new int[]{218, 265, 32});
        DEFINED_COLOR.put("gray", new int[]{128, 128, 128});
        int[] nArray16 = new int[3];
        nArray16[1] = 128;
        DEFINED_COLOR.put("green", nArray16);
        DEFINED_COLOR.put("greenyellow", new int[]{173, 255, 47});
        DEFINED_COLOR.put("grey", new int[]{128, 128, 128});
        DEFINED_COLOR.put("honeydew", new int[]{240, 255, 240});
        DEFINED_COLOR.put("hotpink", new int[]{255, 105, 180});
        DEFINED_COLOR.put("indianred", new int[]{205, 92, 92});
        int[] nArray17 = new int[3];
        nArray17[0] = 75;
        nArray17[2] = 130;
        DEFINED_COLOR.put("indigo", nArray17);
        DEFINED_COLOR.put("ivory", new int[]{255, 255, 240});
        DEFINED_COLOR.put("khaki", new int[]{240, 230, 140});
        DEFINED_COLOR.put("lavender", new int[]{230, 230, 250});
        DEFINED_COLOR.put("lavenderblush", new int[]{255, 240, 245});
        int[] nArray18 = new int[3];
        nArray18[0] = 124;
        nArray18[1] = 242;
        DEFINED_COLOR.put("lawngreen", nArray18);
        DEFINED_COLOR.put("lemonchiffon", new int[]{255, 250, 205});
        DEFINED_COLOR.put("lightblue", new int[]{173, 213, 230});
        DEFINED_COLOR.put("lightcoral", new int[]{240, 128, 128});
        DEFINED_COLOR.put("lightcyan", new int[]{224, 255, 255});
        DEFINED_COLOR.put("lightgoldenrodyellow", new int[]{250, 250, 210});
        DEFINED_COLOR.put("lightgreen", new int[]{144, 238, 144});
        DEFINED_COLOR.put("lightgray", new int[]{211, 211, 211});
        DEFINED_COLOR.put("lightgrey", new int[]{211, 211, 211});
        DEFINED_COLOR.put("lightsalmon", new int[]{255, 160, 122});
        DEFINED_COLOR.put("lightseagreen", new int[]{32, 178, 170});
        DEFINED_COLOR.put("lightskyblue", new int[]{135, 206, 250});
        DEFINED_COLOR.put("lightslategray", new int[]{119, 136, 153});
        DEFINED_COLOR.put("lightslategrey", new int[]{119, 136, 153});
        DEFINED_COLOR.put("lightsteelblue", new int[]{172, 196, 222});
        DEFINED_COLOR.put("lightyellow", new int[]{255, 255, 224});
        int[] nArray19 = new int[3];
        nArray19[1] = 255;
        DEFINED_COLOR.put("lime", nArray19);
        DEFINED_COLOR.put("limegreen", new int[]{50, 205, 50});
        DEFINED_COLOR.put("linen", new int[]{250, 240, 230});
        int[] nArray20 = new int[3];
        nArray20[0] = 255;
        nArray20[2] = 255;
        DEFINED_COLOR.put("magenta", nArray20);
        int[] nArray21 = new int[3];
        nArray21[0] = 128;
        DEFINED_COLOR.put("maroon", nArray21);
        DEFINED_COLOR.put("mediumaquamarine", new int[]{102, 205, 170});
        int[] nArray22 = new int[3];
        nArray22[2] = 205;
        DEFINED_COLOR.put("mediumblue", nArray22);
        DEFINED_COLOR.put("mediumorchid", new int[]{186, 85, 211});
        DEFINED_COLOR.put("mediumpurple", new int[]{147, 112, 219});
        DEFINED_COLOR.put("mediumseagreen", new int[]{60, 179, 113});
        DEFINED_COLOR.put("mediumslateblue", new int[]{123, 104, 238});
        int[] nArray23 = new int[3];
        nArray23[1] = 250;
        nArray23[2] = 154;
        DEFINED_COLOR.put("mediumspringgreen", nArray23);
        DEFINED_COLOR.put("mediumturquoise", new int[]{72, 209, 204});
        DEFINED_COLOR.put("mediumvioletred", new int[]{199, 21, 133});
        DEFINED_COLOR.put("midnightblue", new int[]{25, 25, 112});
        DEFINED_COLOR.put("mintcream", new int[]{245, 255, 250});
        DEFINED_COLOR.put("mistyrose", new int[]{255, 228, 225});
        DEFINED_COLOR.put("moccasin", new int[]{255, 228, 181});
        DEFINED_COLOR.put("navajowhite", new int[]{255, 222, 173});
        int[] nArray24 = new int[3];
        nArray24[2] = 128;
        DEFINED_COLOR.put("navy", nArray24);
        DEFINED_COLOR.put("oldlace", new int[]{253, 245, 230});
        int[] nArray25 = new int[3];
        nArray25[0] = 128;
        nArray25[1] = 128;
        DEFINED_COLOR.put("olive", nArray25);
        DEFINED_COLOR.put("olivedrab", new int[]{107, 142, 35});
        int[] nArray26 = new int[3];
        nArray26[0] = 255;
        nArray26[1] = 165;
        DEFINED_COLOR.put("orange", nArray26);
        int[] nArray27 = new int[3];
        nArray27[0] = 255;
        nArray27[1] = 69;
        DEFINED_COLOR.put("orangered", nArray27);
        DEFINED_COLOR.put("orchid", new int[]{218, 112, 214});
        DEFINED_COLOR.put("palegoldenrod", new int[]{238, 232, 170});
        DEFINED_COLOR.put("palegreen", new int[]{152, 251, 152});
        DEFINED_COLOR.put("paleturquoise", new int[]{175, 238, 238});
        DEFINED_COLOR.put("palevioletred", new int[]{219, 112, 147});
        DEFINED_COLOR.put("papayawhip", new int[]{255, 239, 213});
        DEFINED_COLOR.put("peachpuff", new int[]{255, 218, 185});
        DEFINED_COLOR.put("peru", new int[]{205, 133, 63});
        DEFINED_COLOR.put("pink", new int[]{255, 192, 203});
        DEFINED_COLOR.put("plum", new int[]{221, 160, 221});
        DEFINED_COLOR.put("powderBlue", new int[]{176, 224, 230});
        int[] nArray28 = new int[3];
        nArray28[0] = 128;
        nArray28[2] = 128;
        DEFINED_COLOR.put("purple", nArray28);
        int[] nArray29 = new int[3];
        nArray29[0] = 255;
        DEFINED_COLOR.put("red", nArray29);
        DEFINED_COLOR.put("rosybrown", new int[]{188, 143, 143});
        DEFINED_COLOR.put("royalblue", new int[]{65, 105, 225});
        DEFINED_COLOR.put("saddlebrown", new int[]{139, 69, 19});
        DEFINED_COLOR.put("salmon", new int[]{250, 128, 114});
        DEFINED_COLOR.put("sandybrown", new int[]{244, 164, 96});
        DEFINED_COLOR.put("seagreen", new int[]{46, 139, 87});
        DEFINED_COLOR.put("seashell", new int[]{255, 245, 238});
        DEFINED_COLOR.put("sienna", new int[]{160, 82, 45});
        DEFINED_COLOR.put("silver", new int[]{192, 192, 192});
        DEFINED_COLOR.put("skyblue", new int[]{135, 206, 235});
        DEFINED_COLOR.put("slateblue", new int[]{106, 90, 205});
        DEFINED_COLOR.put("slategray", new int[]{112, 128, 144});
        DEFINED_COLOR.put("slategrey", new int[]{112, 128, 144});
        DEFINED_COLOR.put("snow", new int[]{255, 250, 250});
        int[] nArray30 = new int[3];
        nArray30[1] = 255;
        nArray30[2] = 127;
        DEFINED_COLOR.put("springgreen", nArray30);
        DEFINED_COLOR.put("steelblue", new int[]{70, 130, 180});
        DEFINED_COLOR.put("tan", new int[]{210, 180, 140});
        int[] nArray31 = new int[3];
        nArray31[1] = 128;
        nArray31[2] = 128;
        DEFINED_COLOR.put("teal", nArray31);
        DEFINED_COLOR.put("thistle", new int[]{216, 191, 216});
        DEFINED_COLOR.put("tomato", new int[]{255, 99, 71});
        DEFINED_COLOR.put("turquoise", new int[]{64, 224, 208});
        DEFINED_COLOR.put("violet", new int[]{238, 130, 238});
        DEFINED_COLOR.put("wheat", new int[]{245, 222, 179});
        DEFINED_COLOR.put("white", new int[]{255, 255, 255});
        DEFINED_COLOR.put("whitesmoke", new int[]{245, 245, 245});
        int[] nArray32 = new int[3];
        nArray32[0] = 255;
        nArray32[1] = 255;
        DEFINED_COLOR.put("yellow", nArray32);
        DEFINED_COLOR.put("yellowgreen", new int[]{154, 205, 50});
        DEFINED_COLOR.put("ActiveBorder", CSSColor.disperse(SystemColor.activeCaptionBorder));
        DEFINED_COLOR.put("ActiveCaption", CSSColor.disperse(SystemColor.activeCaption));
        DEFINED_COLOR.put("AppWorkspace", CSSColor.disperse(SystemColor.text));
        DEFINED_COLOR.put("Background", CSSColor.disperse(SystemColor.desktop));
        DEFINED_COLOR.put("ButtonFace", CSSColor.disperse(SystemColor.control));
        DEFINED_COLOR.put("ButtonHighlight", CSSColor.disperse(SystemColor.controlHighlight));
        DEFINED_COLOR.put("ButtonShadow", CSSColor.disperse(SystemColor.controlShadow));
        DEFINED_COLOR.put("ButtonText", CSSColor.disperse(SystemColor.controlText));
        DEFINED_COLOR.put("CaptionText", CSSColor.disperse(SystemColor.activeCaptionText));
        DEFINED_COLOR.put("GrayText", CSSColor.disperse(SystemColor.textInactiveText));
        DEFINED_COLOR.put("Highlight", CSSColor.disperse(SystemColor.textHighlight));
        DEFINED_COLOR.put("HighlightText", CSSColor.disperse(SystemColor.textHighlightText));
        DEFINED_COLOR.put("InactiveBorder", CSSColor.disperse(SystemColor.inactiveCaptionBorder));
        DEFINED_COLOR.put("InactiveCaption", CSSColor.disperse(SystemColor.inactiveCaption));
        DEFINED_COLOR.put("InactiveCaptionText", CSSColor.disperse(SystemColor.inactiveCaptionText));
        DEFINED_COLOR.put("InfoBackground", CSSColor.disperse(SystemColor.info));
        DEFINED_COLOR.put("InfoText", CSSColor.disperse(SystemColor.infoText));
        DEFINED_COLOR.put("Menu", CSSColor.disperse(SystemColor.menu));
        DEFINED_COLOR.put("MenuText", CSSColor.disperse(SystemColor.menuText));
        DEFINED_COLOR.put("Scrollbar", CSSColor.disperse(SystemColor.scrollbar));
        DEFINED_COLOR.put("ThreeDDarkShadow", CSSColor.disperse(SystemColor.controlDkShadow));
        DEFINED_COLOR.put("ThreeDFace", CSSColor.disperse(SystemColor.controlText));
        DEFINED_COLOR.put("ThreeDHighlight", CSSColor.disperse(SystemColor.controlHighlight));
        DEFINED_COLOR.put("ThreeDLightShadow", CSSColor.disperse(SystemColor.controlShadow));
        DEFINED_COLOR.put("ThreeDShadow", CSSColor.disperse(SystemColor.controlLtHighlight));
        DEFINED_COLOR.put("Window", CSSColor.disperse(SystemColor.window));
        DEFINED_COLOR.put("WindowFrame", CSSColor.disperse(SystemColor.windowBorder));
        DEFINED_COLOR.put("WindowText", CSSColor.disperse(SystemColor.windowText));
    }

    public CSSColor(int red, int green, int blue) throws CSSException {
        this(red, green, blue, null);
    }

    public CSSColor(int red, int green, int blue, CSSValue previous) throws CSSException {
        super(previous);
        this.red = this.correctRange(red);
        this.green = this.correctRange(green);
        this.blue = this.correctRange(blue);
        this.actual = "rgb(" + red + ", " + green + ", " + blue + ")";
    }

    public CSSColor(String red, String green, String blue) throws CSSException {
        this(red, green, blue, null);
    }

    public CSSColor(String red, String green, String blue, CSSValue previous) throws CSSException {
        super(previous);
        this.red = this.parseRGB(red);
        this.green = this.parseRGB(green);
        this.blue = this.parseRGB(blue);
        this.actual = "rgb(" + red + ", " + green + ", " + blue + ")";
    }

    public CSSColor(String value) throws CSSException {
        this(value, null);
    }

    public CSSColor(String value, CSSValue previous) throws CSSException {
        super(previous);
        if (value == null || value.length() == 0) {
            throw new IllegalStateException("This HEX color value is null.");
        }
        if (value.charAt(0) == '#') {
            if ((value = value.substring(1)).length() != 3 && value.length() != 6) {
                throw new IllegalStateException("This is a invalid HEX color value. '" + value + "'");
            }
            if (value.length() == 3) {
                this.red = this.parseHex(value.substring(0, 1));
                this.green = this.parseHex(value.substring(1, 2));
                this.blue = this.parseHex(value.substring(2, 3));
            } else {
                this.red = this.parseHex(value.substring(0, 2));
                this.green = this.parseHex(value.substring(2, 4));
                this.blue = this.parseHex(value.substring(4, 6));
            }
            this.actual = "#" + value;
        } else {
            int[] rgb = (int[])DEFINED_COLOR.get(value);
            if (rgb == null) {
                throw new IllegalStateException("This is a invalid color name. '" + value + "'");
            }
            this.red = rgb[0];
            this.green = rgb[1];
            this.blue = rgb[2];
            this.actual = value;
        }
    }

    public String getFunctionName() {
        return "rgb";
    }

    public short getLexicalUnitType() {
        return 27;
    }

    public float getFloatValue() {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " can't execute this method.");
    }

    public String getStringValue() {
        return this.getHexValue();
    }

    public short getPrimitiveType() {
        return 25;
    }

    public CSSPrimitiveValue getBlue() {
        return new CSSNumber(this.blue, null);
    }

    public CSSPrimitiveValue getGreen() {
        return new CSSNumber(this.green, null);
    }

    public CSSPrimitiveValue getRed() {
        return new CSSNumber(this.red, null);
    }

    public String getCssText() {
        return this.actual;
    }

    public RGBColor getRGBColorValue() throws DOMException {
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CSSColor)) {
            return false;
        }
        CSSColor another = (CSSColor)object;
        return this.red == another.red && this.green == another.green && this.blue == another.blue;
    }

    public int hashCode() {
        return Integer.valueOf(this.red).hashCode() + Integer.valueOf(this.green).hashCode() + Integer.valueOf(this.blue).hashCode();
    }

    public String getRGBValue() {
        return "rgb(" + this.red + ", " + this.green + ", " + this.blue + ")";
    }

    public String getHexValue() {
        return "#" + this.convertIntToHex(this.red) + this.convertIntToHex(this.green) + this.convertIntToHex(this.blue);
    }

    public int getRedAsInteger() {
        return this.red;
    }

    public int getGreenAsInteger() {
        return this.green;
    }

    public int getBlueAsInteger() {
        return this.blue;
    }

    private String convertIntToHex(int value) {
        String hex = Integer.toHexString(value);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    private int parseRGB(String value) throws IllegalStateException {
        if (value == null || value.length() == 0) {
            throw new IllegalStateException("This value is null.");
        }
        try {
            int color = -1;
            color = value.charAt(value.length() - 1) == '%' ? (int)(Float.parseFloat(value.substring(0, value.length() - 1)) / 20.0f * 51.0f) : (value.charAt(0) == '+' ? Integer.parseInt(value.substring(1)) : Integer.parseInt(value));
            return this.correctRange(color);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("This value is invalid format.", e);
        }
    }

    private int parseHex(String value) throws IllegalStateException {
        if (value == null || value.length() != 1 && value.length() != 2) {
            throw new IllegalStateException("This value is null or invalid format.");
        }
        try {
            if (value.length() == 1) {
                value = String.valueOf(value) + value;
            }
            int color = Integer.parseInt(value, 16);
            return this.correctRange(color);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("This value is invalid format.", e);
        }
    }

    private int correctRange(int color) {
        if (color < 0) {
            return 0;
        }
        if (255 < color) {
            return 255;
        }
        return color;
    }

    public static final boolean isDefinedColor(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return DEFINED_COLOR.containsKey(name);
    }

    private static int[] disperse(Color color) {
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }
}

