/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.Filter;
import org.w3c.css.sac.ElementSelector;
import org.w3c.dom.Element;

public class ElementFilter
implements Filter,
ElementSelector {
    private String prefix;
    private String namespaceURI;
    private String localName;

    public ElementFilter(String localName) {
        this(null, null, localName);
    }

    public ElementFilter(String prefix, String namespaceURI, String localName) {
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
        this.localName = localName;
        if (localName == null) {
            this.localName = "*";
        }
    }

    public boolean accept(Element target) {
        if (this.prefix != null && this.prefix.length() == 0 && target.getNamespaceURI() != null) {
            return false;
        }
        if (this.namespaceURI != null && !this.namespaceURI.equals(target.getNamespaceURI())) {
            return false;
        }
        if (this.localName.equals("*")) {
            return true;
        }
        return this.localName.equals(target.getLocalName());
    }

    public int getSpecificity() {
        if (this.localName.equals("*")) {
            return 0;
        }
        return 1;
    }

    public int getState() {
        return 0;
    }

    public short getConditionType() {
        return 2;
    }

    public short getSelectorType() {
        return 4;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String toString() {
        if (this.prefix == null) {
            return this.localName;
        }
        return String.valueOf(this.prefix) + "|" + this.localName;
    }
}

