/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.Filter;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.dom.Element;

public class AttributeFilter
implements Filter,
AttributeCondition {
    protected String name = null;
    protected String value = null;

    public AttributeFilter(String name, String value) {
        if (name != null && name.length() != 0) {
            this.name = name;
        }
        this.value = value;
    }

    public boolean accept(Element target) {
        if (target == null || this.name == null) {
            return false;
        }
        String attribute = target.getAttribute(this.name);
        if (attribute == null || attribute.length() == 0) {
            return false;
        }
        return this.acceptAttribute(attribute);
    }

    public int getSpecificity() {
        return 10;
    }

    public int getState() {
        return 0;
    }

    public short getConditionType() {
        return 4;
    }

    public short getSelectorType() {
        return 0;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return null;
    }

    public boolean getSpecified() {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    protected boolean acceptAttribute(String attributeValue) {
        if (this.value == null) {
            return true;
        }
        return this.value.equals(attributeValue);
    }

    public String toString() {
        if (this.value == null) {
            return "[" + this.name + "]";
        }
        return "[" + this.name + "=\"" + this.value + "\"]";
    }
}

