/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.ProcessingFilter;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;
import org.w3c.css.sac.Selector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CSSQuery {
    private static final CueryParser PARSER = new CueryParser();
    private final Document document;

    public CSSQuery(String path) throws IOException {
        this(new File(path));
    }

    public CSSQuery(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public CSSQuery(Document document) {
        this.document = document;
    }

    public Set select(String expression) {
        return this.select(PARSER.parseSelector(expression));
    }

    public Set select(Selector selector) {
        return this.query(this.document, selector);
    }

    private Set query(Node source, Selector selector) {
        Filter filter = CSSUtil.convert(selector);
        if (filter instanceof ProcessingFilter) {
            ProcessingFilter processing = (ProcessingFilter)selector;
            Set results = this.query(source, processing.getSelector());
            if (results.size() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet container = new HashSet();
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                Element result = (Element)iterator.next();
                processing.process(container, result);
            }
            return container;
        }
        return DOMUtil.retrieveElements(source, filter, true);
    }
}

