/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ValueTest.java,v 1.0 2005/08/10 12:24:05 Teletha Exp $
 */
public class ValueTest extends TestCase {

    /*
     * Test method for 'org.w3c.dom.css.CSSValueList.getLength()'
     */
    public void testGetLength() {
        Value value1 = new CSSIdent("1", null);
        Value value2 = new CSSIdent("2", value1);
        Value value3 = new CSSIdent("3", value2);
        Value value4 = new CSSIdent("4", value3);

        assertEquals(4, value1.getLength());
        assertEquals(4, value2.getLength());
        assertEquals(4, value3.getLength());
        assertEquals(4, value4.getLength());
    }

    /*
     * Test method for 'org.w3c.dom.css.CSSValueList.item(int)'
     */
    public void testItem() {
        Value value1 = new CSSIdent("1", null);
        Value value2 = new CSSIdent("2", value1);
        Value value3 = new CSSIdent("3", value2);
        Value value4 = new CSSIdent("4", value3);

        assertEquals("1", value1.item(0).getCssText());
        assertEquals("2", value1.item(1).getCssText());
        assertEquals("3", value4.item(2).getCssText());
        assertEquals("4", value4.item(3).getCssText());
        
        assertNull(value3.item(-1));
        assertNull(value3.item(4));
    }

}
