/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.util;

import java.io.File;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.trix.cuery.filter.AcceptFilter;
import org.trix.cuery.filter.ElementFilter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.stylesheets.StyleSheetList;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: DOMUtilTest.java,v 1.0 2005/07/26 16:54:10 Teletha Exp $
 */
public class DOMUtilTest extends TestCase {

    /* The test document. */
    private static Document document;

    static {
        try {
            File doc = new File("src/test/org/trix/cuery/util/domUtil.xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);

            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(doc);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.getElementsByClassName(Node, String)'
     */
    public void testGetElementsByClassName() {
        Set<Element> results = DOMUtil.getElementsByClassName(document, "class1");
        assertEquals(3, results.size());

        results = DOMUtil.getElementsByClassName(document, "class2");
        assertEquals(2, results.size());

        results = DOMUtil.getElementsByClassName(document, "class3");
        assertEquals(1, results.size());
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.getElementsById(Node, String)'
     */
    public void testGetElementsById() {
        Element results = DOMUtil.getElementById(document, "id1");
        assertEquals("id", results.getTextContent());
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.getElementsByTagName(Node, String)'
     */
    public void testGetElementsByTagName() {
        Set<Element> results = DOMUtil.getElementsByTagName(document, "child");
        assertEquals(9, results.size());

        results = DOMUtil.getElementsByTagName(document, "childs");
        assertEquals(2, results.size());

        results = DOMUtil.getElementsByTagName(document, "nest");
        assertEquals(1, results.size());
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.getSiblingElement(Node)'
     */
    public void testGetSiblingElement() {
        Element result = DOMUtil.getNextElement(DOMUtil.getElementById(document, "id1"));
        assertEquals("text", result.getTextContent());
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.getPosition(Element)'
     */
    public void testGetPosition() {
        assertEquals(6, DOMUtil.getPosition(DOMUtil.getElementById(document, "id1")));
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.getTypedPosition(Element)'
     */
    public void testGetTypedPosition() {
        assertEquals(5, DOMUtil.getTypedPosition(DOMUtil.getElementById(document, "id1")));
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.getStylesheets(Document)'
     */
    public void testGetStylesheets() {
        StyleSheetList list = DOMUtil.getStylesheets(document);
        assertEquals(2, list.getLength());
        assertEquals("test.css", list.item(0).getHref());
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.hasToken(Element, String)'
     */
    public void testHasClass() {
        assertEquals(true, DOMUtil.hasToken(document.getDocumentElement(), "class", "root"));
        assertEquals(false, DOMUtil.hasToken(DOMUtil.getElementById(document, "id1"), "class", "fail"));
    }

    /*
     * Test method for 'org.trix.cuery.util.DOMUtil.retrieveElements(Node, String, Filter, boolean)'
     */
    public void testRetrieveElements() {
        Set<Element> results = DOMUtil.retrieveElements(document, AcceptFilter.SINGLETON, true);
        assertEquals(14, results.size());

        results = DOMUtil.retrieveElements(document, AcceptFilter.SINGLETON, false);
        assertEquals(1, results.size());

        results = DOMUtil.retrieveElements(document, new ElementFilter("child"), true);
        assertEquals(9, results.size());
    }

}
