/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import junit.framework.TestCase;

import org.trix.cuery.parser.CueryParser;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: FilterTest.java,v 1.0 2005/08/05 13:38:10 Teletha Exp $
 */
public class FilterTest extends TestCase {

    /** The test parser. */
    private static CueryParser parser;

    // initialize
    static {
        parser = new CueryParser();
    }

    /*
     * Test method for 'org.trix.cuery.filter.Filter.getSpecificity()'
     */
    public void testGetSpecificity() {
        Filter filter = (Filter) parser.parseSelector("*");
        assertEquals(0, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("html");
        assertEquals(1, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("html body");
        assertEquals(2, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("html > body");
        assertEquals(2, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("p + p + p.alt");
        assertEquals(13, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("#id some text *");
        assertEquals(102, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("div.class1.class2 span.checked");
        assertEquals(32, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("div.class1.class2[title]");
        assertEquals(31, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("p:first-child a");
        assertEquals(12, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("p a:link");
        assertEquals(12, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("p:first-line");
        assertEquals(1, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("p:before");
        assertEquals(1, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("#id:not(foo)");
        assertEquals(101, filter.getSpecificity());
        
        filter = (Filter) parser.parseSelector("h1 + *[rel=up] ");
        assertEquals(11, filter.getSpecificity());
    }

}
