/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import org.trix.cuery.style.Style;
import org.trix.cuery.util.CSSUtil;

import org.w3c.css.sac.InputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSWeaverExample.java,v 1.0 2005/08/13 19:29:48 Teletha Exp $
 */
public class CSSWeaverExample {

    /**
     * Example invocation.
     */
    public static final void main(String[] args) throws Exception {
        // CSSWeaverをインスタンス化します
        CSSWeaver weaver = new CSSWeaver();

        // CSSを準備
        InputSource source = CSSUtil.getSource("src/test/org/trix/cuery/sample.css");

        // 文書作成者のCSSとしてCSSWeaverに登録します
        weaver.addAuthorStylesheet(source);

        // スタイル情報を対象のXMLドキュメントに埋め込みます
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaver.xml");

        // XMLドキュメントから要素をひとつ取り出しています
        Element root = document.getDocumentElement();

        // スタイル情報を要素から取り出します
        Style style = CSSWeaver.getStyle(document.getDocumentElement());
    }
}
