/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSResolution.java,v 1.0 2005/08/09 22:29:58 Teletha Exp $
 */
public class CSSResolution extends AbstractValue {

    /**
     * Create CSSResolution instance.
     * 
     * @param resolution A resolution value.
     * @param previous A previous value of this value.
     */
    public CSSResolution(String resolution, Value previous) {
        super(previous);

        this.stringValue = resolution;
        this.floatValue = Float.parseFloat(resolution);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        return SAC_DIMENSION;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        return floatValue;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.w3c.dom.css.CSSPrimitiveValue#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_DIMENSION;
    }

}
