/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import org.w3c.css.sac.LexicalUnit;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSFunction.java,v 1.0 2005/08/09 22:33:55 Teletha Exp $
 */
public class CSSFunction extends AbstractValue {

    /** The function name. */
    private String name;

    /**
     * Create CSSFunction instance.
     * 
     * @param name A function name.
     * @param expression A expression of this function.
     * @param previous A previous value of this value.
     */
    public CSSFunction(String name, Value expression, Value previous) {
        super(previous);

        this.name = name;
        this.params = expression;

        LexicalUnit value = expression;
        StringBuilder builder = new StringBuilder();

        while (value != null) {
            builder.append(value);
            value = value.getNextLexicalUnit();
        }
        this.stringValue = builder.toString();
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        return SAC_FUNCTION;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        throw new UnsupportedOperationException(getClass().getSimpleName() + " can't execute this method.");
    }

    /**
     * @see org.trix.cuery.value.AbstractValue#getCssText()
     */
    @Override
    public String getCssText() {
        return name + "(" + stringValue + ")";
    }

    /**
     * @see org.trix.cuery.value.AbstractValue#getFunctionName()
     */
    @Override
    public String getFunctionName() {
        return name;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.w3c.dom.css.CSSPrimitiveValue#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_UNKNOWN;
    }

}
