/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSAttrFunction.java,v 1.0 2005/08/09 22:47:49 Teletha Exp $
 */
public class CSSAttrFunction extends CSSFunction {

    /**
     * Create CSSAttrFunction instance.
     * 
     * @param expression A expression of this attr function.
     * @param previous A previous value of this value.
     */
    public CSSAttrFunction(Value expression, Value previous) {
        super("counter", expression, previous);
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getLexicalUnitType()
     */
    @Override
    public short getLexicalUnitType() {
        return SAC_ATTR;
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getPrimitiveType()
     */
    @Override
    public short getPrimitiveType() {
        return CSS_ATTR;
    }
}
