/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.style;

import org.trix.cuery.value.Value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: Style.java,v 1.0 2005/08/10 17:41:31 Teletha Exp $
 */
public interface Style {

    /** The key for style. */
    String KEY = Style.class.getName();

    /**
     * Retrieve the string value of the specified property.
     * 
     * @param name A property name.
     * @return A property value.
     */
    String getProperty(String name);

    /**
     * Retrieve the string value of the specified property. If the specified property cannot be
     * found, defaultValue is returned.
     * 
     * @param name A property name.
     * @param defaultValue A default value.
     * @return A string property value.
     */
    String getProperty(String name, String defaultValue);

    /**
     * Retrieve the int value of the specified property.
     * 
     * @param name A property name.
     * @return A integer property value.
     */
    int getPropertyAsInteger(String name);

    /**
     * Retrieve the int value of the specified property. If the specified property cannot be found,
     * defaultValue is returned.
     * 
     * @param name A property name.
     * @param defaultValue A default value.
     * @return A integer property value.
     */
    int getPropertyAsInteger(String name, int defaultValue);

    /**
     * Retrieve the float value of the specified property.
     * 
     * @param name A property name.
     * @return A float property value.
     */
    float getPropertyAsFloat(String name);

    /**
     * Retrieve the float value of the specified property. If the specified property cannot be
     * found, defaultValue is returned.
     * 
     * @param name A property name.
     * @param defaultValue A default value.
     * @return A float property value.
     */
    float getPropertyAsFloat(String name, int defaultValue);

    /**
     * Return a property value.
     * 
     * @param name A property name.
     * @return A property value.
     */
    Value getPropertyValue(String name);

    /**
     * Check whether this property is important or not.
     * 
     * @param name A property name.
     * @return A result.
     */
    boolean isImportant(String name);
}
